/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.exp;

import edu.stanford.cs.exp.EvalContext;
import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.exp.Value;

public class Compound
extends Expression {
    private Expression function;
    private Expression[] arguments;

    public Compound(Expression fn, Expression[] args) {
        this.function = fn;
        this.arguments = args;
    }

    @Override
    public Expression getFunction() {
        return this.function;
    }

    @Override
    public Expression[] getArgs() {
        return this.arguments;
    }

    @Override
    public Value eval(EvalContext ec) {
        return ec.evalCompound(this);
    }

    public String toString() {
        String result = this.function.toString();
        result = String.valueOf(result) + "(";
        int i = 0;
        while (i < this.arguments.length) {
            if (i > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + this.arguments[i].toString();
            ++i;
        }
        return String.valueOf(result) + ")";
    }

    @Override
    public int getType() {
        return 3;
    }
}

