/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.java2js;

import edu.stanford.cs.java2js.JSErrorEvent;
import edu.stanford.cs.java2js.JSEvent;
import edu.stanford.cs.java2js.URLReader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;

public class JSFile {
    public static final String DEFAULT_CGI_SERVER = "https://web.stanford.edu/class/cs54n/cgi-bin";
    private static String JSFILE = "jsfile";
    private static String server = null;
    private String path;

    public JSFile(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return JSFile.getTail(this.path);
    }

    public String getProtocol() {
        return this.path.substring(0, this.path.indexOf(":") + 1);
    }

    public String getPathname() {
        return this.path.substring(this.path.indexOf(":") + 1);
    }

    public void read(ActionListener listener) {
        String protocol = this.getProtocol();
        if (protocol.equals("http:")) {
            new Thread(new URLReader(this.path, listener)).start();
        } else if (protocol.equals("cgi:")) {
            String request = "/readFile.pl?path=" + this.encode(this.getPathname());
            JSFile.sendHttpRequest(request, listener, this);
        } else {
            ActionEvent e = null;
            try {
                String line;
                BufferedReader rd = new BufferedReader(new FileReader(this.path));
                String result = "";
                while ((line = rd.readLine()) != null) {
                    result = String.valueOf(result) + line + "\n";
                }
                rd.close();
                e = JSEvent.createActionEvent(this, result);
            }
            catch (IOException ex) {
                e = new JSErrorEvent((Object)this, ex.getMessage());
            }
            if (listener != null && e != null) {
                JSEvent.dispatch(listener, e);
            }
        }
    }

    public void write(String text, ActionListener listener) {
        String protocol = this.getProtocol();
        if (protocol.equals("http:")) {
            throw new RuntimeException("Illegal network write");
        }
        if (protocol.equals("cgi:")) {
            String request = "/writeFile.pl?path=" + this.encode(this.getPathname()) + "&text=" + this.encode(text);
            JSFile.sendHttpRequest(request, listener, this);
        } else {
            ActionEvent e = null;
            try {
                BufferedWriter wr = new BufferedWriter(new FileWriter(this.path));
                wr.write(text, 0, text.length());
                wr.close();
                e = JSEvent.createActionEvent(this, "");
            }
            catch (IOException ex) {
                e = new JSErrorEvent((Object)this, ex.getMessage());
            }
            if (listener != null && e != null) {
                JSEvent.dispatch(listener, e);
            }
        }
    }

    public void readDirectory(ActionListener listener) {
        String protocol = this.getProtocol();
        if (protocol.equals("http:")) {
            throw new RuntimeException("Not yet implemented");
        }
        if (protocol.equals("cgi:")) {
            String request = "/readDirectory.pl?path=" + this.encode(this.getPathname());
            JSFile.sendHttpRequest(request, listener, this);
        } else {
            String[] names = new File(this.path).list();
            String text = "";
            int i = 0;
            while (i < names.length) {
                text = String.valueOf(text) + names[i] + "\n";
                ++i;
            }
            ActionEvent e = JSEvent.createActionEvent(this, text);
            if (listener != null) {
                JSEvent.dispatch(listener, e);
            }
        }
    }

    public void readDirectoryTree(ActionListener listener) {
        String protocol = this.getProtocol();
        if (protocol.equals("http:")) {
            throw new RuntimeException("Not yet implemented");
        }
        if (!protocol.equals("cgi:")) {
            throw new RuntimeException("Not yet implemented");
        }
        String request = "/readTree.pl?path=" + this.encode(this.getPathname());
        JSFile.sendHttpRequest(request, listener, this);
    }

    public void delete(ActionListener listener) {
        String protocol = this.getProtocol();
        if (!protocol.equals("cgi:")) {
            throw new RuntimeException("Not yet implemented");
        }
        String request = "/deleteFile.pl?path=" + this.encode(this.getPathname());
        JSFile.sendHttpRequest(request, listener, this);
    }

    public static boolean isLocalFileSystem() {
        return true;
    }

    public static void login(ActionListener listener) {
        String uid = System.getenv("USER");
        ActionEvent e = JSEvent.createActionEvent(JSFILE, uid);
        if (listener != null) {
            JSEvent.dispatch(listener, e);
        }
    }

    public static void sendHttpRequest(String request, ActionListener listener, Object source) {
        if (server == null) {
            throw new RuntimeException("No CGI server defined");
        }
        ActionEvent e = null;
        try {
            String url = String.valueOf(server) + "/" + request;
            InputStream in = new URL(url).openStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(in));
            String text = "";
            String line = rd.readLine();
            if (line == null) {
                e = new JSErrorEvent(source, "Error: No response from server");
            } else if (line.startsWith("Error:")) {
                e = new JSErrorEvent(source, line);
            } else {
                if (!line.equals("OK")) {
                    text = String.valueOf(line) + "\n";
                }
                while ((line = rd.readLine()) != null) {
                    text = String.valueOf(text) + line + "\n";
                }
                e = JSEvent.createActionEvent(source, text);
            }
            rd.close();
        }
        catch (IOException ex) {
            e = new JSErrorEvent(source, ex.getMessage());
        }
        if (e != null && listener != null) {
            listener.actionPerformed(e);
        }
    }

    public static void setCGIServer(String url) {
        server = url;
    }

    public static String getCGIServer() {
        return server;
    }

    public static String getHead(String path) {
        int slashIndex = -1;
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '/' || path.charAt(i) == '\\') {
                slashIndex = i;
            }
            ++i;
        }
        if (slashIndex == -1) {
            return "";
        }
        if (slashIndex == 0) {
            return path.substring(0, 1);
        }
        return path.substring(0, slashIndex);
    }

    public static String getTail(String path) {
        int slashIndex = -1;
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '/' || path.charAt(i) == '\\') {
                slashIndex = i;
            }
            ++i;
        }
        if (slashIndex == -1) {
            return path;
        }
        return path.substring(slashIndex + 1);
    }

    public static String getRoot(String path) {
        int dotIndex = -1;
        int i = 0;
        while (i < path.length()) {
            switch (path.charAt(i)) {
                case '.': {
                    dotIndex = i;
                    break;
                }
                case '/': 
                case '\\': {
                    dotIndex = -1;
                }
            }
            ++i;
        }
        if (dotIndex == -1) {
            return path;
        }
        return path.substring(0, dotIndex);
    }

    public static String getExtension(String path) {
        int dotIndex = -1;
        int i = 0;
        while (i < path.length()) {
            switch (path.charAt(i)) {
                case '.': {
                    dotIndex = i;
                    break;
                }
                case '/': 
                case '\\': {
                    dotIndex = -1;
                }
            }
            ++i;
        }
        if (dotIndex == -1) {
            return "";
        }
        return path.substring(dotIndex);
    }

    public static String[] parseHTMLDirectory(String html) {
        ArrayList<String> files = new ArrayList<String>();
        int start = html.indexOf("Parent Directory");
        if (start == -1) {
            return null;
        }
        while ((start = html.indexOf("<td><a href=\"", start)) != -1) {
            int finish = html.indexOf("\"", start += "<td><a href=\"".length());
            if (finish == -1) {
                return null;
            }
            files.add(html.substring(start, finish));
        }
        int n = files.size();
        String[] array = new String[n];
        int i = 0;
        while (i < n) {
            array[i] = (String)files.get(i);
            ++i;
        }
        return array;
    }

    private String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (IOException ex) {
            return str;
        }
    }
}

