/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jsconsole;

import edu.stanford.cs.java2js.JSEvent;
import edu.stanford.cs.jsconsole.ConsoleTextPane;
import edu.stanford.cs.jsconsole.JSConsoleFocusListener;
import edu.stanford.cs.jsconsole.NBConsole;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JScrollPane;

public class JSConsole
extends JScrollPane
implements NBConsole {
    public static final Font DEFAULT_FONT = Font.decode("Courier New-Bold-18");
    public static final int DEFAULT_MARGIN = 2;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private ConsoleTextPane textPane;
    private Font consoleFont = DEFAULT_FONT;
    private StringBuffer buffer = null;

    public JSConsole() {
        super(20, 30);
        this.textPane = new ConsoleTextPane(this);
        this.textPane.setFont(this.consoleFont);
        this.textPane.setBackground(Color.WHITE);
        this.textPane.setInputColor(Color.BLUE);
        this.textPane.setErrorColor(Color.RED);
        this.textPane.addFocusListener(new JSConsoleFocusListener(this));
        this.setViewportView(this.textPane);
        this.setMargin(2);
    }

    public void setMargin(int pixels) {
        this.setMargin(new Insets(pixels, pixels, pixels, pixels));
    }

    public void setMargin(Insets insets) {
        this.textPane.setMargin(insets);
    }

    @Override
    public void clear() {
        this.textPane.clear();
    }

    @Override
    public boolean isSwingComponent() {
        return true;
    }

    @Override
    public void print(Object x) {
        if (this.buffer == null) {
            this.textPane.print(x.toString(), 0);
        } else {
            this.buffer.append(x);
        }
    }

    @Override
    public void println() {
        if (this.buffer == null) {
            this.textPane.print("\n", 0);
        } else {
            this.buffer.append("\n");
        }
    }

    @Override
    public void println(Object x) {
        this.print(x);
        this.println();
    }

    @Override
    public void log(Object value) {
        this.println(value);
    }

    @Override
    public void showErrorMessage(String msg) {
        this.textPane.print(String.valueOf(msg) + "\n", 2);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.consoleFont = font;
        if (this.textPane != null) {
            this.textPane.setFont(font);
        }
    }

    @Override
    public Font getFont() {
        return this.consoleFont;
    }

    @Override
    public void requestInput(String prompt) {
        this.requestFocus();
        this.print(prompt);
    }

    @Override
    public void forceInput(String input) {
        this.textPane.print(input, 1);
        this.println();
        this.processLine(input);
    }

    @Override
    public void requestFocus() {
        if (this.textPane != null) {
            this.textPane.requestFocus();
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public void startConsoleLog() {
        this.buffer = new StringBuffer();
    }

    @Override
    public String endConsoleLog() {
        String log = this.buffer.toString();
        this.buffer = null;
        return log;
    }

    public void processLine(String str) {
        ActionEvent e = new ActionEvent(this, 1001, str);
        JSEvent.dispatchList(this.actionListeners, e);
    }
}

