/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jscontrols;

import edu.stanford.cs.jscontrols.SpeedControl;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class SpeedControlListener
implements MouseListener,
MouseMotionListener {
    private SpeedControl speedControl;

    public SpeedControlListener(SpeedControl control) {
        this.speedControl = control;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.updateSpeed(e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateSpeed(e.getX(), e.getY());
    }

    public void updateSpeed(int x, int y) {
        int dy = 24 - y;
        int dx = x - 24;
        double theta = Math.toDegrees(Math.atan2(dy, dx));
        if (theta < -135.0) {
            theta += 360.0;
        }
        if (theta > -45.0) {
            this.speedControl.setSpeed((int)Math.round((225.0 - theta) / 2.7));
            this.speedControl.fireAdjustmentListeners();
        }
        this.speedControl.repaint();
    }
}

