/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.controller.Updater;
import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.exp.Value;
import edu.stanford.cs.java2js.JSFile;
import edu.stanford.cs.java2js.JSFileChooser;
import edu.stanford.cs.java2js.JSFrame;
import edu.stanford.cs.java2js.JSProgram;
import edu.stanford.cs.jskarel.CompileUpdater;
import edu.stanford.cs.jskarel.KC;
import edu.stanford.cs.jskarel.KarelChangeListener;
import edu.stanford.cs.jskarel.KarelCommandLoop;
import edu.stanford.cs.jskarel.KarelConsole;
import edu.stanford.cs.jskarel.KarelControlStrip;
import edu.stanford.cs.jskarel.KarelEditor;
import edu.stanford.cs.jskarel.KarelEditorListener;
import edu.stanford.cs.jskarel.KarelFocusListener;
import edu.stanford.cs.jskarel.KarelLayout;
import edu.stanford.cs.jskarel.KarelLoadListener;
import edu.stanford.cs.jskarel.KarelMenuBar;
import edu.stanford.cs.jskarel.KarelParser;
import edu.stanford.cs.jskarel.KarelSaveListener;
import edu.stanford.cs.jskarel.KarelStarter;
import edu.stanford.cs.jskarel.KarelVM;
import edu.stanford.cs.jskarel.KarelWorld;
import edu.stanford.cs.jskarel.KarelWorldEditor;
import edu.stanford.cs.jskarel.KarelWorldView;
import edu.stanford.cs.jskarel.RunUpdater;
import edu.stanford.cs.jskarel.SaveUpdater;
import edu.stanford.cs.jskarel.StepUpdater;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.parser.SyntaxError;
import edu.stanford.cs.svm.SVMFunctionClosure;
import edu.stanford.cs.svm.SVMModule;
import edu.stanford.cs.tokenscanner.TokenScanner;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JSKarel
extends JSProgram {
    private CardLayout uiLayout;
    private JPanel ui;
    private JSFileChooser chooser;
    private KarelCommandLoop commandLoop;
    private KarelConsole console;
    private KarelControlStrip controlStrip;
    private KarelEditor editor;
    private KarelMenuBar menuBar;
    private KarelParser parser;
    private KarelVM kvm;
    private KarelWorld world;
    private KarelWorldEditor worldEditor;
    private KarelWorldView view;
    private String mainFunction;
    private boolean editWorldEnabled;

    public JSKarel() {
        this.createProgramFrame();
        this.getFrame().setPreferredSize(this.getPreferredSizeForScreen());
        this.setTitle("Karel the Robot");
        this.setBackground(KC.APPLICATION_BACKGROUND);
        this.setLayout(new KarelLayout());
        this.mainFunction = null;
        this.world = new KarelWorld();
        this.view = new KarelWorldView(this.world);
        this.parser = new KarelParser();
        this.worldEditor = new KarelWorldEditor(this, this.view);
        this.view.setLook(0);
        this.world.addChangeListener(this.view);
        this.console = new KarelConsole();
        this.console.addFocusListener(new KarelFocusListener(this));
        this.editor = new KarelEditor();
        this.editor.addChangeListener(new KarelEditorListener(this));
        this.chooser = new JSFileChooser(this.getFrame());
        this.chooser.addLoadListener(new KarelLoadListener(this, this.chooser));
        this.chooser.addSaveListener(new KarelSaveListener(this, this.chooser));
        JSFrame consoleFrame = this.createFrame(this.console, "Karel Console");
        JSFrame editorFrame = this.createFrame(this.editor, "Untitled");
        this.editor.setFrame(editorFrame);
        this.uiLayout = new CardLayout();
        this.ui = new JPanel();
        this.ui.setLayout(this.uiLayout);
        this.ui.add((Component)consoleFrame, "console");
        this.ui.add((Component)this.worldEditor, "worldEditor");
        this.uiLayout.show(this.ui, "console");
        this.kvm = new KarelVM(this);
        this.kvm.addChangeListener(new KarelChangeListener(this));
        this.kvm.setErrorHandler(null);
        this.kvm.setDeferredExecution(false);
        this.commandLoop = new KarelCommandLoop(this);
        this.controlStrip = new KarelControlStrip(this);
        this.menuBar = new KarelMenuBar(this);
        this.setMenuBar(this.menuBar);
        this.add(this.view, "world");
        this.add(this.ui, "ui");
        this.add(editorFrame, "editor");
        this.setBackground(KC.APPLICATION_BACKGROUND);
        this.updateControls();
        this.setMinimumSize(this.getMinimumSize());
        this.setEditWorldEnabled(false);
        this.kvm.setSpeed(50);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void run() {
        this.updateChooser();
        this.getCommand();
    }

    public void updateChooser() {
        if (JSProgram.isJavaScript()) {
            String path = "cgi:" + this.getUID() + "/Karel";
            this.chooser.setCurrentDirectory(path);
        } else {
            this.chooser.setCurrentDirectory("examples");
        }
    }

    public void parseProgram() {
        try {
            this.parser.setInput(this.editor.getText());
            String pathname = null;
            if (this.editor.getFile() != null) {
                pathname = this.editor.getFile().getPath();
            }
            SVMModule module = this.parser.readModule(pathname);
            for (String pkg : module.getImports()) {
                if (pkg.equals("turns")) {
                    this.kvm.defineTurns();
                    continue;
                }
                if (pkg.equals("extensions")) {
                    this.kvm.defineExtensions();
                    continue;
                }
                throw new SyntaxError("Unrecognized library name" + pkg);
            }
            boolean first = true;
            for (Expression fn : module.getFunctions()) {
                String name = fn.getArgs()[0].getName();
                if (name.indexOf("#") != -1) {
                    throw new SyntaxError("Top-level functions must have names");
                }
                if (first) {
                    this.mainFunction = name;
                    first = false;
                }
                CodeVector cv = this.parser.compileFunction(fn);
                int[] code = cv.getCode();
                SVMFunctionClosure fc = new SVMFunctionClosure(code, 0, null);
                this.kvm.setGlobal(name, Value.createObject(fc, "FunctionClosure"));
                this.editor.addBreakpointLines(code);
            }
            this.editor.setParseNeeded(false);
        }
        catch (RuntimeException ex) {
            int line = this.editor.getLineNumber(this.parser.getPosition());
            this.editor.showErrorDialog(ex.getMessage(), line);
        }
    }

    public KarelConsole getConsole() {
        return this.console;
    }

    public KarelCommandLoop getCommandLoop() {
        return this.commandLoop;
    }

    public KarelControlStrip getControlStrip() {
        return this.controlStrip;
    }

    public KarelEditor getEditor() {
        return this.editor;
    }

    public KarelWorld getWorld() {
        return this.world;
    }

    public KarelWorldView getWorldView() {
        return this.view;
    }

    public KarelVM getKVM() {
        return this.kvm;
    }

    public void getCommand() {
        this.console.requestInput("-> ");
    }

    public void consoleGainedFocus() {
        if (this.editor.isParseNeeded()) {
            this.editor.setParseNeeded(false);
            this.parseProgram();
            this.updateControls();
        }
    }

    public void executeUserCommand(String line) {
        try {
            if (this.execute(line)) {
                this.getCommand();
            }
        }
        catch (RuntimeException ex) {
            String msg = ex.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + ex;
            }
            this.editor.showErrorDialog(msg, 0);
            this.getCommand();
        }
    }

    public boolean execute(String line) {
        TokenScanner scanner = new TokenScanner();
        scanner.ignoreWhitespace();
        scanner.scanNumbers();
        scanner.scanStrings();
        scanner.setInput(line);
        String cmd = scanner.nextToken();
        if (cmd.length() > 0) {
            if (cmd.equals("quit")) {
                JSKarel.exit(0);
            }
            int startState = 1;
            if (cmd.equals("debug")) {
                startState = 2;
                cmd = scanner.nextToken();
            }
            scanner.verifyToken("(");
            if (cmd.equals("paintCorner")) {
                this.kvm.pushString(scanner.getStringValue(scanner.nextToken()));
            } else if (cmd.equals("pause")) {
                this.kvm.pushDouble(Double.parseDouble(scanner.nextToken()));
            }
            scanner.verifyToken(")");
            String token = scanner.nextToken();
            if (token.equals(";")) {
                token = scanner.nextToken();
            }
            return this.kvm.execute(cmd, startState);
        }
        return true;
    }

    public void statementHook(int offset) {
        int line = this.editor.getSourceLineIndex(offset);
        if (line > 0 && this.editor.isBreakpoint(line)) {
            this.kvm.setState(4);
        }
    }

    public void setEditWorldEnabled(boolean flag) {
        this.editWorldEnabled = flag;
        if (flag) {
            this.uiLayout.show(this.ui, "worldEditor");
            this.view.setWorldMonitor(this.worldEditor);
            this.worldEditor.repaint();
        } else {
            this.uiLayout.show(this.ui, "console");
            this.view.setWorldMonitor(null);
            this.console.repaint();
        }
    }

    public boolean isEditWorldEnabled() {
        return this.editWorldEnabled;
    }

    public void showLoadDialog() {
        this.chooser.setDialogTitle("Load");
        this.chooser.showLoadDialog();
    }

    public void showSaveDialog() {
        this.chooser.setDialogTitle("Save");
        JSFile file = this.editor.getFile();
        if (file != null) {
            file.write(this.editor.getText(), null);
        } else {
            this.chooser.showSaveDialog();
        }
    }

    public void newFileCommand() {
        this.editor.setFile(null);
        this.editor.setText("");
        this.editor.clearOffsetTable();
        this.editor.repaint();
    }

    public String scanFilename(TokenScanner scanner) {
        String filename = "";
        while (scanner.hasMoreTokens()) {
            filename = String.valueOf(filename) + scanner.nextToken();
        }
        return filename;
    }

    public void loadWorld(String str) {
        this.world.load(str);
        this.getCommand();
    }

    public void saveWorld() {
        this.chooser.setDialogTitle("Save World");
        String pathname = this.chooser.getPath();
        if (pathname != null) {
            this.chooser.setPath(String.valueOf(JSFile.getRoot(pathname)) + ".w");
        }
        this.chooser.showSaveDialog();
    }

    public void updateControls() {
        this.controlStrip.update();
        this.menuBar.update();
    }

    public Updater createSaveUpdater() {
        return new SaveUpdater(this);
    }

    public boolean isSaveEnabled() {
        return this.editor.getFile() == null || this.editor.isSaveNeeded();
    }

    public Updater createRunUpdater() {
        return new RunUpdater(this);
    }

    public boolean isRunEnabled() {
        return !this.kvm.isRunning() && this.getMainFunction() != null;
    }

    public Updater createCompileUpdater() {
        return new CompileUpdater(this);
    }

    public boolean isCompileEnabled() {
        return this.editor.isParseNeeded();
    }

    public Updater createStepUpdater() {
        return new StepUpdater(this);
    }

    public boolean isStepEnabled() {
        return !this.kvm.isRunning() && this.getMainFunction() != null;
    }

    public void setVMSpeed(double worldSpeed) {
        int vmSpeed = (int)Math.round(this.getWorld().getSpeed() * 100.0);
        this.kvm.setSpeed(vmSpeed);
        this.controlStrip.setSpeed(vmSpeed);
    }

    public String getMainFunction() {
        return this.kvm.isGlobal("main") ? "main" : this.mainFunction;
    }

    private Dimension getPreferredSizeForScreen() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int width = Math.min(1200, (int)size.getWidth() - 20);
        int height = Math.min(800, (int)size.getHeight() - 60);
        return new Dimension(width, height);
    }

    private JSFrame createFrame(JComponent component, String title) {
        return new JSFrame(component, title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new KarelStarter());
    }
}

