/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.direction.Direction;
import edu.stanford.cs.jskarel.KarelWorld;
import java.awt.Point;

public class Karel {
    private static final int NORTH = 0;
    private static final int EAST = 1;
    private static final int SOUTH = 2;
    private static final int WEST = 3;
    private KarelWorld world = null;
    private int x = 1;
    private int y = 1;
    private int dir = 1;
    private int beepers = 99999999;

    public void run() {
    }

    public void move() {
        this.checkWorld("move");
        if (this.world.checkWall(this.x, this.y, this.dir)) {
            throw new RuntimeException("Karel is blocked");
        }
        Point pt = Direction.adjacentPoint(new Point(this.x, this.y), this.dir);
        this.setLocation(pt.x, pt.y);
        this.world.trace();
    }

    public void turnLeft() {
        this.checkWorld("turnLeft");
        this.setDirection(Direction.leftFrom(this.dir));
        this.world.trace();
    }

    public void turnRight() {
        this.checkWorld("turnRight");
        this.setDirection(Direction.rightFrom(this.dir));
        this.world.trace();
    }

    public void turnAround() {
        this.checkWorld("turnAround");
        this.setDirection(Direction.oppositeDirection(this.dir));
        this.world.trace();
    }

    public void pickBeeper() {
        this.checkWorld("pickBeeper");
        int nb = this.world.getBeepersOnCorner(this.x, this.y);
        if (nb < 1) {
            throw new RuntimeException("pickBeeper: No beepers on this corner");
        }
        this.world.setBeepersOnCorner(this.x, this.y, KarelWorld.adjustBeepers(nb, -1));
        this.setBeepersInBag(KarelWorld.adjustBeepers(this.getBeepersInBag(), 1));
        this.world.trace();
    }

    public void putBeeper() {
        this.checkWorld("putBeeper");
        int nb = this.getBeepersInBag();
        if (nb < 1) {
            throw new RuntimeException("putBeeper: No beepers in bag");
        }
        int cb = KarelWorld.adjustBeepers(this.world.getBeepersOnCorner(this.x, this.y), 1);
        this.world.setBeepersOnCorner(this.x, this.y, cb);
        this.setBeepersInBag(KarelWorld.adjustBeepers(nb, -1));
        this.world.trace();
    }

    public boolean frontIsClear() {
        this.checkWorld("frontIsClear");
        return !this.world.checkWall(this.x, this.y, this.dir);
    }

    public boolean frontIsBlocked() {
        this.checkWorld("frontIsBlocked");
        return this.world.checkWall(this.x, this.y, this.dir);
    }

    public boolean leftIsClear() {
        this.checkWorld("leftIsClear");
        return !this.world.checkWall(this.x, this.y, Direction.leftFrom(this.dir));
    }

    public boolean leftIsBlocked() {
        this.checkWorld("leftIsBlocked");
        return this.world.checkWall(this.x, this.y, Direction.leftFrom(this.dir));
    }

    public boolean rightIsClear() {
        this.checkWorld("rightIsClear");
        return !this.world.checkWall(this.x, this.y, Direction.rightFrom(this.dir));
    }

    public boolean rightIsBlocked() {
        this.checkWorld("rightIsBlocked");
        return this.world.checkWall(this.x, this.y, Direction.rightFrom(this.dir));
    }

    public boolean beepersPresent() {
        this.checkWorld("beepersPresent");
        return this.world.getBeepersOnCorner(this.x, this.y) > 0;
    }

    public boolean noBeepersPresent() {
        this.checkWorld("noBeepersPresent");
        return this.world.getBeepersOnCorner(this.x, this.y) == 0;
    }

    public boolean beepersInBag() {
        this.checkWorld("beepersInBag");
        return this.getBeepersInBag() > 0;
    }

    public boolean noBeepersInBag() {
        this.checkWorld("noBeepersInBag");
        return this.getBeepersInBag() == 0;
    }

    public boolean facingNorth() {
        this.checkWorld("facingNorth");
        return this.dir == 0;
    }

    public boolean facingEast() {
        this.checkWorld("facingEast");
        return this.dir == 1;
    }

    public boolean facingSouth() {
        this.checkWorld("facingSouth");
        return this.dir == 2;
    }

    public boolean facingWest() {
        this.checkWorld("facingWest");
        return this.dir == 3;
    }

    public boolean notFacingNorth() {
        this.checkWorld("notFacingNorth");
        return this.dir != 0;
    }

    public boolean notFacingEast() {
        this.checkWorld("notFacingEast");
        return this.dir != 1;
    }

    public boolean notFacingSouth() {
        this.checkWorld("notFacingSouth");
        return this.dir != 2;
    }

    public boolean notFacingWest() {
        this.checkWorld("notFacingWest");
        return this.dir != 3;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int x, int y) {
        if (this.world != null && this.world.outOfBounds(x, y)) {
            throw new RuntimeException("setLocation: Out of bounds");
        }
        this.x = x;
        this.y = y;
    }

    public int getDirection() {
        return this.dir;
    }

    public void setDirection(int dir) {
        this.dir = dir;
        if (this.world != null) {
            this.world.fireChangeListeners();
        }
    }

    public int getBeepersInBag() {
        return this.beepers;
    }

    public void setBeepersInBag(int nBeepers) {
        this.beepers = nBeepers;
    }

    public KarelWorld getWorld() {
        return this.world;
    }

    public void setWorld(KarelWorld world) {
        this.world = world;
    }

    public void checkWorld(String caller) {
        if (this.world == null) {
            throw new RuntimeException(String.valueOf(caller) + ": Karel is not in a world");
        }
    }
}

