/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.java2js.JSPlatform;
import edu.stanford.cs.jscontrols.CompileControl;
import edu.stanford.cs.jscontrols.JSControl;
import edu.stanford.cs.jscontrols.LoadControl;
import edu.stanford.cs.jscontrols.NewControl;
import edu.stanford.cs.jscontrols.ResetControl;
import edu.stanford.cs.jscontrols.RunControl;
import edu.stanford.cs.jscontrols.SaveControl;
import edu.stanford.cs.jscontrols.SpeedControl;
import edu.stanford.cs.jscontrols.StepControl;
import edu.stanford.cs.jscontrols.StepOverControl;
import edu.stanford.cs.jskarel.JSKarel;
import edu.stanford.cs.jskarel.KarelConsole;
import edu.stanford.cs.jskarel.KarelEditWorldControl;
import edu.stanford.cs.jskarel.KarelEditor;
import edu.stanford.cs.jskarel.KarelVM;
import edu.stanford.cs.jskarel.RunControlUpdater;
import edu.stanford.cs.svmtools.SVMEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;

public class KarelControlStrip
implements ActionListener,
AdjustmentListener {
    private ActionEvent lastEvent;
    private ArrayList<JSControl> controls;
    private JSKarel app;
    private KarelConsole console;
    private KarelEditWorldControl editWorldControl;
    private KarelVM kvm;
    private CompileControl compileControl;
    private LoadControl loadControl;
    private NewControl newControl;
    private ResetControl resetControl;
    private RunControl runControl;
    private SaveControl saveControl;
    private SpeedControl speedControl;
    private StepControl stepControl;
    private StepOverControl stepOverControl;

    public KarelControlStrip(JSKarel app) {
        this.app = app;
        this.kvm = app.getKVM();
        this.console = app.getConsole();
        this.lastEvent = null;
        this.initControlStrip();
    }

    public JSKarel getApplication() {
        return this.app;
    }

    public void update() {
        for (JSControl control : this.controls) {
            control.update();
            control.repaint();
        }
    }

    public void setSpeed(int speed) {
        this.speedControl.setSpeed(speed);
        this.speedControl.repaint();
    }

    public void adjustDelay() {
        this.kvm.setSpeed(this.speedControl.getSpeed());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isDuplicateEvent(e)) {
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd.equals("Reset")) {
            this.console.clear();
            this.kvm.stopAction();
            this.kvm.setState(5);
            this.app.updateControls();
        } else if (cmd.equals("Compile")) {
            this.app.parseProgram();
            this.app.updateControls();
        } else if (cmd.equals("Run")) {
            this.app.parseProgram();
            this.adjustDelay();
            if (this.kvm.getState() == 4) {
                this.kvm.startAction();
            } else {
                String main = this.app.getMainFunction();
                this.console.forceInput(String.valueOf(main) + "();");
            }
        } else if (cmd.equals("Stop")) {
            this.adjustDelay();
            this.kvm.stopAction();
        } else if (cmd.equals("Step")) {
            this.adjustDelay();
            if (this.kvm.getState() == 4) {
                this.kvm.stepAction();
            } else {
                String main = this.app.getMainFunction();
                this.console.forceInput("debug " + main + "();");
            }
        } else if (cmd.equals("StepOver")) {
            this.adjustDelay();
            if (this.kvm.getState() == 4) {
                this.kvm.callAction();
            } else {
                String main = this.app.getMainFunction();
                this.console.forceInput("debug " + main + "();");
            }
        } else if (cmd.equals("Edit World")) {
            this.app.setEditWorldEnabled(!this.app.isEditWorldEnabled());
        } else if (cmd.equals("Load")) {
            this.kvm.stopAction();
            this.app.showLoadDialog();
        } else if (cmd.equals("Save")) {
            this.kvm.stopAction();
            this.app.showSaveDialog();
        } else if (cmd.equals("New")) {
            this.kvm.stopAction();
            this.app.newFileCommand();
        } else if (cmd.equals("LargerFont")) {
            KarelEditor editor = this.app.getEditor();
            editor.setFont(SVMEditor.largerFont(editor.getFont()));
            this.console.setFont(SVMEditor.largerFont(this.console.getFont()));
        } else if (cmd.equals("SmallerFont")) {
            KarelEditor editor = this.app.getEditor();
            editor.setFont(SVMEditor.smallerFont(editor.getFont()));
            this.console.setFont(SVMEditor.smallerFont(this.console.getFont()));
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.adjustDelay();
    }

    protected void initControlStrip() {
        this.controls = new ArrayList();
        this.loadControl = new LoadControl();
        this.loadControl.addActionListener(this);
        this.app.addControl(this.loadControl);
        this.controls.add(this.loadControl);
        this.saveControl = new SaveControl();
        this.saveControl.addActionListener(this);
        this.saveControl.setUpdater(this.app.createSaveUpdater());
        this.app.addControl(this.saveControl);
        this.controls.add(this.saveControl);
        this.newControl = new NewControl();
        this.newControl.addActionListener(this);
        this.app.addControl(this.newControl);
        this.controls.add(this.newControl);
        this.editWorldControl = new KarelEditWorldControl();
        this.editWorldControl.addActionListener(this);
        this.app.addControl(this.editWorldControl);
        this.controls.add(this.editWorldControl);
        this.resetControl = new ResetControl();
        this.resetControl.addActionListener(this);
        this.app.addControl(this.resetControl);
        this.controls.add(this.resetControl);
        this.speedControl = new SpeedControl();
        this.speedControl.addAdjustmentListener(this);
        this.app.addControl(this.speedControl);
        this.controls.add(this.speedControl);
        this.runControl = new RunControl();
        this.runControl.addActionListener(this);
        this.runControl.setUpdater(new RunControlUpdater(this.app));
        this.app.addControl(this.runControl);
        this.controls.add(this.runControl);
        this.stepControl = new StepControl();
        this.stepControl.addActionListener(this);
        this.stepControl.setUpdater(this.app.createStepUpdater());
        this.app.addControl(this.stepControl);
        this.controls.add(this.stepControl);
        this.stepOverControl = new StepOverControl();
        this.stepOverControl.addActionListener(this);
        this.stepOverControl.setUpdater(this.app.createStepUpdater());
        this.app.addControl(this.stepOverControl);
        this.controls.add(this.stepOverControl);
        this.compileControl = new CompileControl();
        this.compileControl.addActionListener(this);
        this.compileControl.setUpdater(this.app.createCompileUpdater());
        this.app.addControl(this.compileControl);
        this.controls.add(this.compileControl);
    }

    public boolean isDuplicateEvent(ActionEvent e) {
        if (JSPlatform.isJavaScript() || !JSPlatform.isMacOSX()) {
            return false;
        }
        if (this.lastEvent != null && e.getWhen() - this.lastEvent.getWhen() < 100L) {
            this.lastEvent = null;
            return true;
        }
        this.lastEvent = e;
        return false;
    }
}

