/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.exp.Value;
import edu.stanford.cs.java2js.JSColor;
import edu.stanford.cs.jskarel.KarelVM;
import edu.stanford.cs.jskarel.KarelWorld;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMMethod;
import java.awt.Color;
import java.awt.Point;

class KarelCornerColorIs
extends SVMMethod {
    KarelCornerColorIs() {
    }

    @Override
    public void execute(SVM svm, Value receiver) {
        KarelVM kvm = (KarelVM)svm;
        KarelWorld world = kvm.getWorld();
        Point pt = world.getKarel().getLocation();
        Color c1 = JSColor.decode(kvm.popString());
        Color c2 = world.getCornerColor(pt.x, pt.y);
        if (c1 == null || c2 == null) {
            kvm.pushBoolean(c1 == c2);
        } else {
            kvm.pushBoolean(c1.getRGB() == c2.getRGB());
        }
    }
}

