/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.jskarel.KarelGraphics;
import edu.stanford.cs.jskarel.KarelWorldEditor;
import edu.stanford.cs.jskarel.MapTool;
import java.awt.Graphics;
import java.awt.Rectangle;

class KarelTool
extends MapTool {
    private int dir;

    public KarelTool(int x, int y, int dir) {
        super(x, y, 20, 20);
        this.dir = dir;
    }

    @Override
    public void paint(Graphics g, KarelWorldEditor editor) {
        Rectangle r = this.getBounds();
        int cx = r.x + r.width / 2;
        int cy = r.y + r.height / 2;
        if (editor.getView().getLook() == 1) {
            KarelGraphics.drawFancyKarel(g, cx, cy, r.width, this.dir, null);
        } else {
            KarelGraphics.drawSimpleKarel(g, cx, cy, r.width, this.dir, null);
        }
    }

    @Override
    public void toolAction(KarelWorldEditor editor) {
        editor.getWorld().getKarel().setDirection(this.dir);
    }
}

