/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.jskarel.KC;
import edu.stanford.cs.jskarel.KarelWorld;
import edu.stanford.cs.jskarel.KarelWorldEditor;
import edu.stanford.cs.jskarel.MapTool;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

class ResizeTool
extends MapTool {
    private String label = "";
    private boolean highlighted = false;

    public ResizeTool(int x, int y) {
        super(x, y, 46, 46);
    }

    @Override
    public void paint(Graphics g, KarelWorldEditor editor) {
        KarelWorld world = editor.getWorld();
        Rectangle r = this.getBounds();
        g.setColor(Color.WHITE);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.BLACK);
        g.drawRect(r.x, r.y, r.width, r.height);
        if (editor.getSelectedTool() == this) {
            this.drawLabel(g, this.label);
        } else {
            this.drawLabel(g, String.valueOf(world.getNCols()) + "x" + world.getNRows());
        }
    }

    @Override
    public void toolAction(KarelWorldEditor editor) {
        KarelWorld world = editor.getWorld();
        editor.setSelectedTool(this);
        editor.requestFocus();
        this.highlighted = true;
        this.label = String.valueOf(world.getNCols()) + "x" + world.getNRows();
    }

    public void processKey(KarelWorldEditor editor, int ch) {
        if (this.highlighted) {
            this.label = "";
            this.highlighted = false;
        }
        int times = this.label.indexOf("x");
        if (Character.isDigit(ch)) {
            this.label = String.valueOf(this.label) + (char)ch;
        } else if (times > 0 && times < this.label.length() - 1 && (ch == 10 || ch == 13)) {
            int width = Integer.parseInt(this.label.substring(0, times));
            int height = Integer.parseInt(this.label.substring(times + 1));
            editor.getWorld().resize(width, height);
            editor.setSelectedTool(null);
        } else if (times == -1 && (ch == 120 || ch == 88 || ch == 42)) {
            this.label = String.valueOf(this.label) + "x";
        } else if (this.label.length() > 0 && (ch == 127 || ch == 8)) {
            this.label = this.label.substring(0, this.label.length() - 1);
        }
        editor.repaint();
    }

    private void drawLabel(Graphics g, String str) {
        Rectangle r = this.getBounds();
        int times = str.indexOf("x");
        if (times == -1) {
            g.setFont(KC.RESIZE_FONT);
            FontMetrics fm = g.getFontMetrics();
            int x = r.x + (r.width - fm.stringWidth(str)) / 2;
            int y = r.y + r.height / 2 + 4;
            g.drawString(str, x, y);
        } else {
            String s1 = str.substring(0, times);
            String s2 = str.substring(times + 1);
            g.setFont(KC.RESIZE_X_FONT);
            FontMetrics fm = g.getFontMetrics();
            int wx = fm.stringWidth("x");
            g.setFont(KC.RESIZE_FONT);
            fm = g.getFontMetrics();
            int w1 = fm.stringWidth(s1);
            int w2 = fm.stringWidth(s2);
            int x = r.x + (r.width - (w1 + wx + w2)) / 2;
            int y = r.y + r.height / 2 + 4;
            if (this.highlighted) {
                g.setColor(KC.RESIZE_BG);
                g.fillRect(x + -2, y + -10, w1 + wx + w2 + 4, 12);
                g.setColor(Color.BLACK);
            }
            g.drawString(s1, x, y);
            g.drawString(s2, x + w1 + wx, y);
            g.setFont(KC.RESIZE_X_FONT);
            g.drawString("x", x + w1, y);
        }
    }
}

