/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.parser.SyntaxError;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMClass;
import edu.stanford.cs.svm.SVMMethod;
import edu.stanford.cs.svm.SVMNameInstruction;
import edu.stanford.cs.svm.SVMStackFrame;
import edu.stanford.cs.tokenscanner.TokenScanner;

class CALLM_Ins
extends SVMNameInstruction {
    public CALLM_Ins() {
        super("CALLM", 97);
    }

    @Override
    public void assemble(CodeVector cv, TokenScanner scanner) {
        String token = scanner.nextToken();
        if (scanner.getTokenType(token) != 1) {
            throw new SyntaxError("CALLM requires a class and method name");
        }
        scanner.verifyToken(".");
        token = String.valueOf(token) + "." + scanner.nextToken();
        cv.addWord(0x61000000 | cv.stringRef(token));
    }

    @Override
    public void execute(SVM svm, int addr) {
        SVMStackFrame cf = svm.getCurrentFrame();
        cf.setArgumentCount(svm.getNARGSCount());
        String name = svm.getString(addr);
        int dot = name.lastIndexOf(".");
        String cname = dot == -1 ? this.receiverClass(svm) : name.substring(0, dot);
        String mname = name.substring(dot + 1);
        SVMClass c = SVMClass.forName(cname);
        SVMMethod m = c.getMethod(mname);
        m.execute(svm, null);
    }

    @Override
    public String unparse(SVM svm, int addr) {
        return "CALLM " + svm.getString(addr);
    }

    private String receiverClass(SVM svm) {
        int nArgs = svm.getArgumentCount();
        return svm.peekBack(nArgs).getClassName();
    }
}

