/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.parser.SyntaxError;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMInstruction;
import edu.stanford.cs.svm.SVMStackFrame;
import edu.stanford.cs.tokenscanner.TokenScanner;

class CALL_Ins
extends SVMInstruction {
    public CALL_Ins() {
        super("CALL", 96);
    }

    @Override
    public void assemble(CodeVector cv, TokenScanner scanner) {
        String token = scanner.nextToken();
        int type = scanner.getTokenType(token);
        if (type == 2) {
            cv.addWord(this.getCode() << 24 | Integer.parseInt(token));
        } else if (type == 1) {
            String next = scanner.nextToken();
            if (next.equals(".")) {
                token = String.valueOf(token) + "." + scanner.nextToken();
                cv.addWord(0x61000000 | cv.stringRef(token));
            } else {
                scanner.saveToken(next);
                cv.addWord(0x60000000 | cv.labelRef(token));
            }
        } else {
            throw new SyntaxError("Illegal argument " + token);
        }
    }

    @Override
    public void execute(SVM svm, int addr) {
        svm.pushFrame();
        SVMStackFrame cf = svm.getCurrentFrame();
        cf.setReturnAddress(svm.getPC());
        cf.setArgumentCount(svm.getNARGSCount());
        svm.setPC(addr);
    }

    @Override
    public String unparse(SVM svm, int addr) {
        return "CALL " + addr;
    }
}

