/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.exp.Value;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMInstruction;

abstract class LogicalOp
extends SVMInstruction {
    public LogicalOp(String name, int code) {
        super(name, code);
    }

    @Override
    public void execute(SVM svm, int addr) {
        Value rhs = svm.pop();
        Value lhs = svm.pop();
        int lhsType = lhs.getType();
        int rhsType = rhs.getType();
        if (lhsType == 66 && rhsType == 66) {
            int v1 = lhs.getBooleanValue() ? -1 : 0;
            int v2 = rhs.getBooleanValue() ? -1 : 0;
            svm.pushBoolean(this.applyInteger(v1, v2) != 0);
        } else {
            int x = lhs.getIntegerValue();
            int y = rhs.getIntegerValue();
            svm.pushInteger(this.applyInteger(x, y));
        }
    }

    public abstract int applyInteger(int var1, int var2);
}

