/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.tokenscanner;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Stack;

public class TokenScanner {
    public static final int EOF = -1;
    public static final int SEPARATOR = 0;
    public static final int WORD = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    public static final int OPERATOR = 4;
    private static final int INITIAL_STATE = 0;
    private static final int BEFORE_DECIMAL_POINT = 1;
    private static final int AFTER_DECIMAL_POINT = 2;
    private static final int STARTING_EXPONENT = 3;
    private static final int FOUND_EXPONENT_SIGN = 4;
    private static final int SCANNING_EXPONENT = 5;
    private static final int SCANNING_HEX = 6;
    private static final int FINAL_STATE = 7;
    private Reader input = null;
    private String wordChars = "";
    private String savedChars;
    private Stack<String> savedTokens = new Stack();
    private ArrayList<String> operators = new ArrayList();
    private int cpos = 0;
    private boolean ignoreWhitespaceFlag = false;
    private boolean ignoreCommentsFlag = false;
    private boolean scanNumbersFlag = false;
    private boolean scanStringsFlag = false;

    public TokenScanner() {
    }

    public TokenScanner(String str) {
        this();
        this.setInput(str);
    }

    public TokenScanner(Reader rd) {
        this();
        this.setInput(rd);
    }

    public void setInput(String str) {
        this.setInput(new StringReader(str));
    }

    public void setInput(Reader rd) {
        this.savedChars = "";
        this.savedTokens.clear();
        this.cpos = 0;
        this.input = rd;
    }

    public boolean hasMoreTokens() {
        String token = this.nextToken();
        this.saveToken(token);
        return !token.isEmpty();
    }

    public String nextToken() {
        if (!this.savedTokens.isEmpty()) {
            return this.savedTokens.pop();
        }
        return this.scanToken();
    }

    public void saveToken(String token) {
        this.savedTokens.push(token);
    }

    public int getPosition() {
        if (this.savedTokens.isEmpty()) {
            return this.cpos;
        }
        return this.cpos - this.savedTokens.peek().length();
    }

    public void ignoreWhitespace() {
        this.ignoreWhitespaceFlag = true;
    }

    public void ignoreComments() {
        this.ignoreCommentsFlag = true;
    }

    public void scanNumbers() {
        this.scanNumbersFlag = true;
    }

    public void scanStrings() {
        this.scanStringsFlag = true;
    }

    public void addWordCharacters(String str) {
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (this.wordChars.indexOf(ch) == -1) {
                this.wordChars = String.valueOf(this.wordChars) + ch;
            }
            ++i;
        }
    }

    public boolean isWordCharacter(int ch) {
        if (ch == -1) {
            return false;
        }
        return Character.isLetterOrDigit(ch) || this.wordChars.indexOf((char)ch) >= 0;
    }

    public void addOperator(String op) {
        this.operators.add(op);
    }

    public void verifyToken(String expected) {
        String token = this.nextToken();
        if (token.equals(expected)) {
            return;
        }
        String msg = "";
        msg = token.equals("") ? "Missing " + expected : "Found " + token + " when expecting " + expected;
        throw new RuntimeException(msg);
    }

    public int getTokenType(String token) {
        if (token == null || token.length() == 0) {
            return -1;
        }
        char ch = token.charAt(0);
        if (Character.isWhitespace(ch)) {
            return 0;
        }
        if (Character.isDigit(ch)) {
            return 2;
        }
        if (ch == '\"' || ch == '\'') {
            return 3;
        }
        if (this.isWordCharacter(ch)) {
            return 1;
        }
        return 4;
    }

    public int getChar() {
        try {
            ++this.cpos;
            if (!this.savedChars.isEmpty()) {
                char ch = this.savedChars.charAt(0);
                this.savedChars = this.savedChars.substring(1);
                return ch;
            }
            int ch = this.input.read();
            if (ch == 13 && (ch = this.input.read()) != 10) {
                this.savedChars = String.valueOf((char)ch) + this.savedChars;
                ch = 10;
            }
            return ch;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public void ungetChar(int ch) {
        --this.cpos;
        if (this.input instanceof PushbackReader) {
            try {
                ((PushbackReader)this.input).unread(ch);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (ch >= 0) {
            this.savedChars = String.valueOf((char)ch) + this.savedChars;
        }
    }

    public String getStringValue(String token) {
        String str = "";
        int start = 0;
        int finish = token.length();
        if (finish > 1 && (token.charAt(0) == '\"' || token.charAt(0) == '\'')) {
            start = 1;
            --finish;
        }
        int i = start;
        while (i < finish) {
            char ch = token.charAt(i);
            if (ch == '\\') {
                if (Character.isDigit(ch = token.charAt(++i)) || ch == 'x') {
                    int base = 8;
                    int maxDigits = 3;
                    if (ch == 'x') {
                        base = 16;
                        maxDigits = 2;
                        ++i;
                    }
                    int result = 0;
                    int digit = 0;
                    int limit = Math.min(finish, i + maxDigits);
                    while (i < limit) {
                        ch = token.charAt(i);
                        if (Character.isDigit(ch)) {
                            digit = ch - 48;
                        } else if (base == 16 && ch >= 'A' && ch <= 'F') {
                            digit = ch - 65 + 10;
                        } else {
                            if (base != 16 || ch < 97 || ch > 102) break;
                            digit = ch - 97 + 10;
                        }
                        result = base * result + digit;
                        ++i;
                    }
                    ch = (char)result;
                    --i;
                } else {
                    switch (ch) {
                        case 'a': {
                            ch = '\u0007';
                            break;
                        }
                        case 'b': {
                            ch = '\b';
                            break;
                        }
                        case 'f': {
                            ch = '\f';
                            break;
                        }
                        case 'n': {
                            ch = '\n';
                            break;
                        }
                        case 'r': {
                            ch = '\r';
                            break;
                        }
                        case 't': {
                            ch = '\t';
                            break;
                        }
                        case 'v': {
                            ch = '\u000b';
                            break;
                        }
                        case '\"': {
                            ch = '\"';
                            break;
                        }
                        case '\'': {
                            ch = '\'';
                            break;
                        }
                        case '\\': {
                            ch = '\\';
                        }
                    }
                }
            }
            str = String.valueOf(str) + ch;
            ++i;
        }
        return str;
    }

    private String scanToken() {
        int ch = this.scanChar();
        if (ch == -1) {
            return "";
        }
        if (this.scanNumbersFlag && Character.isDigit(ch)) {
            this.ungetChar(ch);
            return this.scanNumber();
        }
        if (this.isWordCharacter(ch)) {
            this.ungetChar(ch);
            return this.scanWord();
        }
        if (this.scanStringsFlag && (ch == 34 || ch == 39)) {
            this.ungetChar(ch);
            return this.scanString();
        }
        String op = "" + (char)ch;
        while (this.isOperatorPrefix(op)) {
            ch = this.getChar();
            if (ch == -1) break;
            op = String.valueOf(op) + (char)ch;
        }
        while (op.length() > 1 && !this.isOperator(op)) {
            this.ungetChar(op.charAt(op.length() - 1));
            op = op.substring(0, op.length() - 1);
        }
        return op;
    }

    private int scanChar() {
        int ch;
        block6: {
            int peek;
            boolean slashStarComment = false;
            boolean slashSlashComment = false;
            while (true) {
                ch = this.getChar();
                if (slashStarComment) {
                    if (ch == -1) {
                        throw new RuntimeException("Unclosed comment");
                    }
                    peek = this.getChar();
                    if (ch == 42 && peek == 47) {
                        slashStarComment = false;
                        continue;
                    }
                    this.ungetChar(peek);
                    continue;
                }
                if (slashSlashComment) {
                    if (ch != 10 && ch != -1) continue;
                    slashSlashComment = false;
                    if (ch != 10 || !this.isOperator("\n")) continue;
                    this.ungetChar(ch);
                    continue;
                }
                if (this.ignoreWhitespaceFlag && Character.isWhitespace(ch) && !this.isOperator(Character.toString((char)ch))) continue;
                if (!this.ignoreCommentsFlag || ch != 47) break block6;
                peek = this.getChar();
                if (peek == 42) {
                    slashStarComment = true;
                    continue;
                }
                if (peek != 47) break;
                slashSlashComment = true;
            }
            this.ungetChar(peek);
        }
        return ch;
    }

    private String scanWord() {
        String str = "";
        int ch = this.getChar();
        while (this.isWordCharacter(ch)) {
            str = String.valueOf(str) + (char)ch;
            ch = this.getChar();
        }
        this.ungetChar(ch);
        return str;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String scanNumber() {
        String str = "";
        int state = 0;
        int ec = 69;
        block9: while (state != 7) {
            int ch = this.getChar();
            switch (state) {
                case 0: {
                    if (ch == 48) {
                        int peek = this.getChar();
                        if (peek == 120 || peek == 88) {
                            str = "0x";
                            state = 6;
                            continue block9;
                        }
                        this.ungetChar(peek);
                    }
                    state = 1;
                    break;
                }
                case 1: {
                    if (ch == 46) {
                        state = 2;
                        break;
                    }
                    if (ch == 69 || ch == 101) {
                        state = 3;
                        break;
                    }
                    if (Character.isDigit(ch)) break;
                    state = 7;
                    break;
                }
                case 2: {
                    if (ch == 69 || ch == 101) {
                        ec = ch;
                        state = 3;
                        break;
                    }
                    if (Character.isDigit(ch)) break;
                    state = 7;
                    break;
                }
                case 3: {
                    if (ch == 43 || ch == 45) {
                        state = 4;
                        break;
                    }
                    if (Character.isDigit(ch)) {
                        state = 5;
                        break;
                    }
                    state = 7;
                    break;
                }
                case 4: {
                    if (Character.isDigit(ch)) {
                        state = 5;
                        break;
                    }
                    this.ungetChar(ch);
                    ch = ec;
                    state = 7;
                    break;
                }
                case 5: {
                    if (Character.isDigit(ch)) break;
                    state = 7;
                    break;
                }
                case 6: {
                    if (Character.isDigit(ch) || "ABCDEFabcdef".indexOf(ch) != -1) break;
                    state = 7;
                }
            }
            if (state == 7) {
                this.ungetChar(ch);
                return str;
            }
            str = String.valueOf(str) + (char)ch;
        }
        return str;
    }

    private String scanString() {
        char ch;
        char delim = (char)this.getChar();
        String str = "" + delim;
        char prev = '\u0000';
        while ((ch = this.getChar()) != '\uffffffff' && (ch != delim || prev == '\\')) {
            str = String.valueOf(str) + (char)ch;
            prev = ch;
        }
        return String.valueOf(str) + delim;
    }

    private boolean isOperator(String op) {
        int i = 0;
        while (i < this.operators.size()) {
            if (this.operators.get(i).equals(op)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isOperatorPrefix(String op) {
        int i = 0;
        while (i < this.operators.size()) {
            if (this.operators.get(i).startsWith(op)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

