/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GCanvas;
import edu.stanford.cs.graphics.GContainer;
import edu.stanford.cs.graphics.GIterator;
import edu.stanford.cs.graphics.GObject;
import edu.stanford.cs.graphics.GObjectList;
import edu.stanford.cs.graphics.GPoint;
import edu.stanford.cs.graphics.GRectangle;
import edu.stanford.cs.graphics.GTransform;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Iterator;

public class GCompound
extends GObject
implements GContainer,
Iterable<GObject> {
    private GObjectList contents = new GObjectList(this);
    private transient GObject lastObject;
    private transient GObject dragObject;

    @Override
    public void add(GObject gobj) {
        this.contents.add(gobj);
        this.repaint();
    }

    @Override
    public final void add(GObject gobj, double x, double y) {
        gobj.setLocation(x, y);
        this.add(gobj);
    }

    @Override
    public final void add(GObject gobj, GPoint pt) {
        this.add(gobj, pt.getX(), pt.getY());
    }

    @Override
    public void remove(GObject gobj) {
        this.contents.remove(gobj);
        this.repaint();
    }

    @Override
    public void removeAll() {
        this.contents.removeAll();
        this.repaint();
    }

    @Override
    public int getElementCount() {
        return this.contents.getElementCount();
    }

    @Override
    public GObject getElement(int index) {
        return this.contents.getElement(index);
    }

    @Override
    public GObject getElementAt(double x, double y) {
        return this.contents.getElementAt(x, y, false);
    }

    @Override
    public final GObject getElementAt(GPoint pt) {
        return this.getElementAt(pt.getX(), pt.getY());
    }

    @Override
    public Iterator<GObject> iterator() {
        return new GIterator(this, 0);
    }

    public Iterator<GObject> iterator(int direction) {
        return new GIterator(this, direction);
    }

    @Override
    public Object clone() {
        try {
            GCompound clone = (GCompound)super.clone();
            clone.contents = new GObjectList(clone, this.contents);
            return clone;
        }
        catch (Exception CloneNotSupportedException) {
            throw new RuntimeException("Impossible exception");
        }
    }

    public final GPoint getCanvasPoint(GPoint localPoint) {
        return this.getCanvasPoint(localPoint.getX(), localPoint.getY());
    }

    public GPoint getCanvasPoint(double x, double y) {
        GContainer c = this;
        while (c instanceof GCompound) {
            GCompound comp = c;
            x += comp.getX();
            y += comp.getY();
            c = comp.getParent();
        }
        return new GPoint(x, y);
    }

    public final GPoint getLocalPoint(GPoint canvasPoint) {
        return this.getLocalPoint(canvasPoint.getX(), canvasPoint.getY());
    }

    public GPoint getLocalPoint(double x, double y) {
        GContainer c = this;
        while (c instanceof GCompound) {
            GCompound comp = c;
            x -= comp.getX();
            y -= comp.getY();
            c = comp.getParent();
        }
        return new GPoint(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GRectangle localBounds(GTransform ctm) {
        GRectangle bb = new GRectangle();
        GObjectList gObjectList = this.contents;
        synchronized (gObjectList) {
            int n = this.contents.getElementCount();
            int i = 0;
            while (i < n) {
                GObject obj = this.contents.getElement(i);
                GTransform t = new GTransform(ctm);
                t.translate(obj.getX(), obj.getY());
                t.concatenate(obj.getCTM());
                GRectangle r = obj.localBounds(t);
                if (i == 0) {
                    bb = r;
                } else {
                    bb.add(r);
                }
                ++i;
            }
        }
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean localContains(double x, double y) {
        GObjectList gObjectList = this.contents;
        synchronized (gObjectList) {
            int n = this.contents.getElementCount();
            int i = 0;
            while (true) {
                if (i >= n) {
                    return false;
                }
                if (this.contents.getElement(i).contains(x, y)) {
                    return true;
                }
                ++i;
            }
        }
    }

    @Override
    protected void paint2d(Graphics2D g) {
        this.contents.mapPaint(g);
    }

    protected void sendToFront(GObject gobj) {
        this.contents.sendToFront(gobj);
        this.repaint();
    }

    protected void sendToBack(GObject gobj) {
        this.contents.sendToBack(gobj);
        this.repaint();
    }

    protected void sendForward(GObject gobj) {
        this.contents.sendForward(gobj);
        this.repaint();
    }

    protected void sendBackward(GObject gobj) {
        this.contents.sendBackward(gobj);
        this.repaint();
    }

    @Override
    protected void fireMouseListeners(MouseEvent e) {
        int id;
        if (super.areMouseListenersEnabled()) {
            super.fireMouseListeners(e);
            return;
        }
        GPoint pt = new GPoint((double)e.getX() - this.getX(), (double)e.getY() - this.getY());
        GObject gobj = this.getElementAt(pt);
        MouseEvent newEvent = null;
        if (gobj != this.lastObject) {
            if (this.lastObject != null) {
                newEvent = GCanvas.createMouseEvent(this.lastObject, 505, e);
                this.lastObject.fireMouseListeners(newEvent);
            }
            if (gobj != null) {
                newEvent = GCanvas.createMouseEvent(gobj, 504, e);
                gobj.fireMouseListeners(newEvent);
            }
        }
        this.lastObject = gobj;
        if (this.dragObject != null) {
            gobj = this.dragObject;
        }
        if (gobj != null && (id = e.getID()) != 505 && id != 504) {
            if (id == 501) {
                this.dragObject = gobj;
            } else if (id == 502) {
                this.dragObject = null;
            }
            newEvent = GCanvas.createMouseEvent(gobj, id, e);
            gobj.fireMouseListeners(newEvent);
        }
        if (newEvent != null && newEvent.isConsumed()) {
            e.consume();
        }
    }

    @Override
    protected boolean areMouseListenersEnabled() {
        if (super.areMouseListenersEnabled()) {
            return true;
        }
        return this.contents.areMouseListenersEnabled();
    }
}

