/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GCanvas;
import edu.stanford.cs.graphics.GCompound;
import edu.stanford.cs.graphics.GContainer;
import edu.stanford.cs.graphics.GDimension;
import edu.stanford.cs.graphics.GFillable;
import edu.stanford.cs.graphics.GPoint;
import edu.stanford.cs.graphics.GRectangle;
import edu.stanford.cs.graphics.GResizable;
import edu.stanford.cs.graphics.GScalable;
import edu.stanford.cs.graphics.GTransform;
import java.awt.AWTEventMulticaster;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;

public abstract class GObject
implements Cloneable,
GScalable {
    private GCompound compoundParent;
    private GTransform ctm = new GTransform();
    private GTransform itm = null;
    private Color objectColor;
    private double lineWidth = 1.0;
    private double x;
    private double y;
    private boolean transformed = false;
    private boolean isVisible = true;
    private boolean mouseListenersEnabled = false;
    private transient MouseListener mouseListener;
    private transient MouseMotionListener mouseMotionListener;
    private transient ActionListener actionListener;
    private transient GContainer transientParent;

    protected GObject() {
    }

    public void paint(Graphics g) {
        if (this.isVisible) {
            Graphics2D g2d = this.createTransformedGraphics(g);
            this.paint2d(g2d);
            g2d.dispose();
        }
    }

    public GRectangle getBounds() {
        GRectangle r = this.localBounds(this.ctm);
        r.translate(this.x, this.y);
        return r;
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
        this.repaint();
    }

    public final void setLocation(GPoint pt) {
        this.setLocation(pt.getX(), pt.getY());
    }

    public GPoint getLocation() {
        return new GPoint(this.x, this.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void move(double dx, double dy) {
        this.setLocation(this.x + dx, this.y + dy);
    }

    public final void movePolar(double r, double theta) {
        double radians = theta * Math.PI / 180.0;
        this.move(r * Math.cos(radians), -r * Math.sin(radians));
    }

    public GDimension getSize() {
        GRectangle bounds = this.getBounds();
        return new GDimension(bounds.getWidth(), bounds.getHeight());
    }

    public double getWidth() {
        return this.getBounds().getWidth();
    }

    public double getHeight() {
        return this.getBounds().getHeight();
    }

    public boolean contains(double x, double y) {
        GTransform t = new GTransform();
        t.translate(this.x, this.y);
        t.concatenate(this.getCTM());
        GPoint pt = t.inverseTransform(x, y);
        return this.localContains(pt.getX(), pt.getY());
    }

    public boolean contains(GPoint pt) {
        return this.contains(pt.getX(), pt.getY());
    }

    public void sendToFront() {
        if (this.compoundParent != null) {
            this.compoundParent.sendToFront(this);
        } else if (this.transientParent instanceof GCanvas) {
            ((GCanvas)this.transientParent).sendToFront(this);
        } else if (this.transientParent != null) {
            try {
                Class<?> parentClass = this.transientParent.getClass();
                Class[] types = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] args = new Object[]{this};
                Method fn = parentClass.getMethod("sendToFront", types);
                if (fn != null) {
                    fn.invoke((Object)this.transientParent, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mouseListenersEnabled) {
            this.updateEnabledList();
        }
    }

    public void sendToBack() {
        if (this.compoundParent != null) {
            this.compoundParent.sendToBack(this);
        } else if (this.transientParent instanceof GCanvas) {
            ((GCanvas)this.transientParent).sendToBack(this);
        } else if (this.transientParent != null) {
            try {
                Class<?> parentClass = this.transientParent.getClass();
                Class[] types = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] args = new Object[]{this};
                Method fn = parentClass.getMethod("sendToBack", types);
                if (fn != null) {
                    fn.invoke((Object)this.transientParent, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mouseListenersEnabled) {
            this.updateEnabledList();
        }
    }

    public void sendForward() {
        if (this.compoundParent != null) {
            this.compoundParent.sendForward(this);
        } else if (this.transientParent instanceof GCanvas) {
            ((GCanvas)this.transientParent).sendForward(this);
        } else if (this.transientParent != null) {
            try {
                Class<?> parentClass = this.transientParent.getClass();
                Class[] types = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] args = new Object[]{this};
                Method fn = parentClass.getMethod("sendForward", types);
                if (fn != null) {
                    fn.invoke((Object)this.transientParent, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mouseListenersEnabled) {
            this.updateEnabledList();
        }
    }

    public void sendBackward() {
        if (this.compoundParent != null) {
            this.compoundParent.sendBackward(this);
        } else if (this.transientParent instanceof GCanvas) {
            ((GCanvas)this.transientParent).sendBackward(this);
        } else if (this.transientParent != null) {
            try {
                Class<?> parentClass = this.transientParent.getClass();
                Class[] types = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] args = new Object[]{this};
                Method fn = parentClass.getMethod("sendBackward", types);
                if (fn != null) {
                    fn.invoke((Object)this.transientParent, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mouseListenersEnabled) {
            this.updateEnabledList();
        }
    }

    public void setColor(Color color) {
        this.objectColor = color;
        this.repaint();
    }

    public Color getColor() {
        GObject obj = this;
        while (obj.objectColor == null) {
            GContainer parent = obj.getParent();
            if (parent instanceof GObject) {
                obj = (GObject)((Object)parent);
                continue;
            }
            if (parent instanceof Component) {
                return ((Component)((Object)parent)).getForeground();
            }
            return Color.BLACK;
        }
        return obj.objectColor;
    }

    public void setLineWidth(double width) {
        this.lineWidth = width;
        this.repaint();
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void rotate(double theta) {
        this.ctm.rotate(theta);
        this.itm = null;
        this.transformed = true;
        this.repaint();
    }

    @Override
    public void scale(double sx, double sy) {
        this.ctm.scale(sx, sy);
        this.itm = null;
        this.transformed = true;
        this.repaint();
    }

    @Override
    public final void scale(double sf) {
        this.scale(sf, sf);
    }

    public void shear(double sx, double sy) {
        this.ctm.shear(sx, sy);
        this.itm = null;
        this.transformed = true;
        this.repaint();
    }

    public void translate(double tx, double ty) {
        this.ctm.translate(tx, ty);
        this.itm = null;
        this.transformed = true;
        this.repaint();
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
        this.repaint();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public String toString() {
        String name = this.getClass().getName();
        if (name.startsWith("acm.graphics.")) {
            name = name.substring("acm.graphics.".length());
        }
        return String.valueOf(name) + "[" + this.paramString() + "]";
    }

    public GContainer getParent() {
        return this.compoundParent != null ? this.compoundParent : this.transientParent;
    }

    public void addMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, listener);
        this.mouseListenersEnabled = true;
        this.updateEnabledList();
    }

    public void removeMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, listener);
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, listener);
        this.mouseListenersEnabled = true;
        this.updateEnabledList();
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, listener);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    public void fireActionEvent(String actionCommand) {
        this.fireActionEvent(new ActionEvent(this, 1001, actionCommand));
    }

    public void fireActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    public Object clone() {
        try {
            GObject clone = (GObject)super.clone();
            clone.compoundParent = null;
            clone.transientParent = null;
            clone.mouseListener = null;
            clone.mouseMotionListener = null;
            clone.actionListener = null;
            if (clone.ctm != null) {
                clone.ctm = new GTransform(clone.ctm);
            }
            return clone;
        }
        catch (Exception CloneNotSupportedException) {
            throw new RuntimeException("Impossible exception");
        }
    }

    public void setParent(GContainer parent) {
        if (parent instanceof GCompound) {
            this.compoundParent = (GCompound)parent;
        } else {
            this.transientParent = parent;
        }
    }

    protected abstract void paint2d(Graphics2D var1);

    protected abstract GRectangle localBounds(GTransform var1);

    protected abstract boolean localContains(double var1, double var3);

    protected boolean isTransformed() {
        return this.transformed;
    }

    protected void fireMouseListeners(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                if (this.mouseListener == null) break;
                this.mouseListener.mousePressed(e);
                break;
            }
            case 502: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseReleased(e);
                break;
            }
            case 500: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseClicked(e);
                break;
            }
            case 505: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseExited(e);
                break;
            }
            case 504: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseEntered(e);
                break;
            }
            case 503: {
                if (this.mouseMotionListener == null) break;
                this.mouseMotionListener.mouseMoved(e);
                break;
            }
            case 506: {
                if (this.mouseMotionListener == null) break;
                this.mouseMotionListener.mouseDragged(e);
            }
        }
    }

    protected boolean areMouseListenersEnabled() {
        return this.mouseListenersEnabled;
    }

    protected Color getObjectColor() {
        return this.objectColor;
    }

    protected GTransform getCTM() {
        return this.ctm;
    }

    protected GTransform getITM() {
        if (this.itm == null) {
            this.itm = this.ctm.createInverse();
        }
        return this.itm;
    }

    protected Graphics2D createTransformedGraphics(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        Color objectColor = this.getObjectColor();
        if (objectColor != null) {
            g2d.setColor(objectColor);
        }
        AffineTransform at = new AffineTransform(this.ctm.getScaleX(), this.ctm.getShearY(), this.ctm.getShearX(), this.ctm.getScaleY(), this.ctm.getTranslateX(), this.ctm.getTranslateY());
        g2d.translate(this.getX(), this.getY());
        g2d.setStroke(new BasicStroke((float)this.lineWidth));
        g2d.transform(at);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g2d;
    }

    protected String paramString() {
        String param = "";
        if (this instanceof GResizable) {
            GRectangle r = this.getBounds();
            param = String.valueOf(param) + "bounds=(" + GObject.dts(r.getX()) + ", " + GObject.dts(r.getY()) + ", " + GObject.dts(r.getWidth()) + ", " + GObject.dts(r.getHeight()) + ")";
        } else {
            GPoint pt = this.getLocation();
            param = String.valueOf(param) + "location=(" + GObject.dts(pt.getX()) + ", " + GObject.dts(pt.getY()) + ")";
        }
        if (this.objectColor != null) {
            param = String.valueOf(param) + ", color=" + GObject.colorName(this.objectColor);
        }
        if (this instanceof GFillable) {
            param = String.valueOf(param) + ", filled=" + ((GFillable)((Object)this)).isFilled();
            Color fillColor = ((GFillable)((Object)this)).getFillColor();
            if (fillColor != null && fillColor != this.objectColor) {
                param = String.valueOf(param) + ", fillColor=" + GObject.colorName(fillColor);
            }
        }
        return param;
    }

    protected static String dts(double d) {
        if (d == (double)((long)d)) {
            return "" + (long)d;
        }
        return "" + d;
    }

    protected static String colorName(Color color) {
        if (color.equals(Color.BLACK)) {
            return "BLACK";
        }
        if (color.equals(Color.BLUE)) {
            return "BLUE";
        }
        if (color.equals(Color.CYAN)) {
            return "CYAN";
        }
        if (color.equals(Color.DARK_GRAY)) {
            return "DARK_GRAY";
        }
        if (color.equals(Color.GRAY)) {
            return "GRAY";
        }
        if (color.equals(Color.GREEN)) {
            return "GREEN";
        }
        if (color.equals(Color.LIGHT_GRAY)) {
            return "LIGHT_GRAY";
        }
        if (color.equals(Color.MAGENTA)) {
            return "MAGENTA";
        }
        if (color.equals(Color.ORANGE)) {
            return "ORANGE";
        }
        if (color.equals(Color.PINK)) {
            return "PINK";
        }
        if (color.equals(Color.RED)) {
            return "RED";
        }
        if (color.equals(Color.WHITE)) {
            return "WHITE";
        }
        if (color.equals(Color.YELLOW)) {
            return "YELLOW";
        }
        int rgb = color.getRGB() & 0xFFFFFF;
        return "0x" + Integer.toString(rgb, 16).toUpperCase();
    }

    protected Component getComponent() {
        GContainer parent = this.getParent();
        while (parent instanceof GObject) {
            parent = ((GObject)((Object)parent)).getParent();
        }
        return parent instanceof Component ? (Component)((Object)parent) : null;
    }

    protected void updateEnabledList() {
        Component comp = this.getComponent();
        if (comp instanceof GCanvas) {
            ((GCanvas)comp).updateEnabledList();
        }
    }

    protected void repaint() {
        GContainer parent = this.getParent();
        while (parent instanceof GObject) {
            parent = ((GObject)((Object)parent)).getParent();
        }
        if (parent instanceof GCanvas) {
            ((GCanvas)parent).conditionalRepaint();
        }
    }
}

