/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.DirectGif89Frame;
import edu.stanford.cs.graphics.Gif89Frame;
import edu.stanford.cs.graphics.IndexGif89Frame;
import edu.stanford.cs.graphics.ReverseColorMap;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;

class GifColorTable {
    private int[] theColors = new int[256];
    private int colorDepth;
    private int transparentIndex = -1;
    private int ciCount = 0;
    private ReverseColorMap ciLookup;

    GifColorTable() {
        this.ciLookup = new ReverseColorMap();
    }

    GifColorTable(Color[] colors) {
        int n2copy = Math.min(this.theColors.length, colors.length);
        int i = 0;
        while (i < n2copy) {
            this.theColors[i] = colors[i].getRGB();
            ++i;
        }
    }

    int getDepth() {
        return this.colorDepth;
    }

    int getTransparent() {
        return this.transparentIndex;
    }

    void setTransparent(int color_index) {
        this.transparentIndex = color_index;
    }

    void processPixels(Gif89Frame gf) throws IOException {
        if (gf instanceof DirectGif89Frame) {
            this.filterPixels((DirectGif89Frame)gf);
        } else {
            this.trackPixelUsage((IndexGif89Frame)gf);
        }
    }

    void closePixelProcessing() {
        this.colorDepth = this.computeColorDepth(this.ciCount);
    }

    void encode(OutputStream os) throws IOException {
        int palette_size = 1 << this.colorDepth;
        int i = 0;
        while (i < palette_size) {
            os.write(this.theColors[i] >> 16 & 0xFF);
            os.write(this.theColors[i] >> 8 & 0xFF);
            os.write(this.theColors[i] & 0xFF);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void filterPixels(DirectGif89Frame dgf) throws IOException {
        if (this.ciLookup == null) {
            throw new IOException("RGB frames require palette autodetection");
        }
        argb_pixels = (int[])dgf.getPixelSource();
        ci_pixels = dgf.getPixelSink();
        npixels = argb_pixels.length;
        i = 0;
        while (i < npixels) {
            block7: {
                argb = argb_pixels[i];
                if (argb >>> 24 >= 128) ** GOTO lbl-1000
                if (this.transparentIndex != -1) break block7;
                this.transparentIndex = this.ciCount;
                ** GOTO lbl-1000
            }
            if (argb != this.theColors[this.transparentIndex]) {
                ci_pixels[i] = (byte)this.transparentIndex;
            } else if ((color_index = this.ciLookup.getPaletteIndex(argb & 0xFFFFFF)) == -1) {
                if (this.ciCount == 256) {
                    throw new IOException("can't encode as GIF (> 256 colors)");
                }
                this.theColors[this.ciCount] = argb;
                this.ciLookup.put(argb & 0xFFFFFF, this.ciCount);
                ci_pixels[i] = (byte)this.ciCount;
                ++this.ciCount;
            } else {
                ci_pixels[i] = (byte)color_index;
            }
            ++i;
        }
    }

    private void trackPixelUsage(IndexGif89Frame igf) {
        byte[] ci_pixels = (byte[])igf.getPixelSource();
        int npixels = ci_pixels.length;
        int i = 0;
        while (i < npixels) {
            if (ci_pixels[i] >= this.ciCount) {
                this.ciCount = ci_pixels[i] + 1;
            }
            ++i;
        }
    }

    private int computeColorDepth(int colorcount) {
        if (colorcount <= 2) {
            return 1;
        }
        if (colorcount <= 4) {
            return 2;
        }
        if (colorcount <= 16) {
            return 4;
        }
        return 8;
    }
}

