/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jsconsole;

import edu.stanford.cs.java2js.JSEvent;
import edu.stanford.cs.jsconsole.JavaConsoleMonitor;
import edu.stanford.cs.jsconsole.NBConsole;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class JavaConsole
implements NBConsole {
    private ArrayList<ActionListener> listeners = new ArrayList();
    private StringBuffer buffer = null;

    @Override
    public void clear() {
        if (this.buffer != null) {
            this.buffer = new StringBuffer();
        }
    }

    @Override
    public boolean isSwingComponent() {
        return false;
    }

    @Override
    public void print(Object value) {
        if (this.buffer == null) {
            System.out.print(value);
        } else {
            this.buffer.append(value);
        }
    }

    @Override
    public void println() {
        if (this.buffer == null) {
            System.out.println();
        } else {
            this.buffer.append("\n");
        }
    }

    @Override
    public void println(Object value) {
        if (this.buffer == null) {
            System.out.println(value);
        } else {
            this.buffer.append(value + "\n");
        }
    }

    @Override
    public void log(Object value) {
        this.println(value);
    }

    @Override
    public void showErrorMessage(String msg) {
        System.err.println(msg);
    }

    @Override
    public void requestInput(String prompt) {
        System.out.print(prompt);
        Thread t = new Thread(new JavaConsoleMonitor(this));
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void forceInput(String input) {
        this.println(input);
        this.processInput(input);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void startConsoleLog() {
        this.buffer = new StringBuffer();
    }

    @Override
    public String endConsoleLog() {
        String log = this.buffer.toString();
        this.buffer = null;
        return log;
    }

    public void processInput(String str) {
        ActionEvent e = new ActionEvent(this, 1001, str);
        JSEvent.dispatchList(this.listeners, e);
    }
}

