/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jsmenu;

import edu.stanford.cs.controller.Updatable;
import edu.stanford.cs.controller.Updater;
import java.awt.Toolkit;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class JSMenuItem
extends JMenuItem
implements Updatable {
    private Updater updater;

    public JSMenuItem(String text) {
        this(text, (String)null);
    }

    public JSMenuItem(String text, String shortcut) {
        super(text);
        if (shortcut != null) {
            this.setAccelerator(JSMenuItem.parseAccelerator(shortcut));
        }
    }

    public JSMenuItem(AbstractAction action) {
        this(action, null);
    }

    public JSMenuItem(AbstractAction action, String shortcut) {
        super(action);
        if (shortcut != null) {
            this.setAccelerator(JSMenuItem.parseAccelerator(shortcut));
        }
    }

    public static KeyStroke parseAccelerator(String str) {
        String modifiers;
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean isMeta = mask == 256 || mask == 4;
        String string = modifiers = isMeta ? "meta" : "ctrl";
        if (str.startsWith("^")) {
            modifiers = String.valueOf(modifiers) + " shift";
            str = str.substring(1);
        }
        return KeyStroke.getKeyStroke(String.valueOf(modifiers) + " " + str);
    }

    @Override
    public void update() {
        if (this.updater != null) {
            this.updater.update(this);
        }
    }

    @Override
    public void setUpdater(Updater updater) {
        this.updater = updater;
    }
}

