/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjs;

import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.exp.Value;
import edu.stanford.cs.file.FileLib;
import edu.stanford.cs.java2js.JSEvent;
import edu.stanford.cs.java2js.JSPackage;
import edu.stanford.cs.java2js.JSPlatform;
import edu.stanford.cs.jsconsole.JavaConsole;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.parser.SyntaxError;
import edu.stanford.cs.shellargs.ShellArgs;
import edu.stanford.cs.sjs.SJSCompiler;
import edu.stanford.cs.sjs.SJSInterpreterMonitor;
import edu.stanford.cs.sjs.SJSParser;
import edu.stanford.cs.sjs.SJSReadEvalPrintLoop;
import edu.stanford.cs.sjs.SJSVM;
import edu.stanford.cs.sjslib.core.Package_core;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMModule;
import edu.stanford.cs.svm.SVMPackage;
import edu.stanford.cs.svm.SVMProgram;
import edu.stanford.cs.svm.SVMSourceMarker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeSet;

public class SJSInterpreter
extends SVMProgram {
    public static final String PROGRAM_PATH = ".:programs";
    private static final String[] OPTIONS = new String[]{"-c", "-e", "-help", "-i", "-j", "-l", "-script <file>", "-t", "-x"};
    private static final String[] REQUIREJS_HEADER = new String[]{"requirejs.config( { baseUrl: \"js\" });"};
    private static final String[] REQUIREJS_TRAILER = new String[]{"          });"};
    private static final String INDENT = "             ";
    private JavaConsole console;
    private SJSInterpreterMonitor monitor;
    private SJSParser parser;
    private SJSReadEvalPrintLoop repl;
    private SJSVM svm = (SJSVM)this.getSVM();
    private static TreeSet<String> librariesLoaded = new TreeSet();
    private static boolean traceFlag = false;

    public SJSInterpreter() {
        this.setCurrentDirectory(System.getProperty("user.dir"));
    }

    public boolean isInterpreter() {
        return true;
    }

    public void start(String[] args) {
        ShellArgs options = new ShellArgs(args, OPTIONS);
        if (options.isOptionSpecified("-help")) {
            options.showUsage("sjs <options> <files>", OPTIONS);
        } else {
            this.runSJS(options);
        }
    }

    public SJSParser getParser() {
        return this.parser;
    }

    public static void setTraceFlag(boolean flag) {
        traceFlag = flag;
    }

    public static boolean getTraceFlag() {
        return traceFlag;
    }

    public static void showError(RuntimeException ex, SVM svm, int index) {
        SVMSourceMarker marker;
        String msg = ex.getMessage();
        if (msg == null || msg.isEmpty()) {
            msg = ex.toString();
        }
        if ((marker = svm.getSourceMarker(index)) != null) {
            if (msg.endsWith("expecting ;")) {
                msg = "Missing ;";
                marker = svm.getSourceMarker(marker.getStartingIndex() - 2);
                index = marker.getSourceLine().length() + marker.getStartingIndex() + 1;
            }
            System.err.println(marker.getSourceLine());
            if (ex instanceof SyntaxError) {
                String caret = "^";
                int n = index - marker.getStartingIndex() - 1;
                int i = 0;
                while (i < n) {
                    caret = " " + caret;
                    ++i;
                }
                System.err.println(caret);
                msg = "Syntax error: " + msg;
            } else {
                msg = "Runtime error: " + msg;
            }
        }
        System.err.println(msg);
    }

    @Override
    protected SVM createSVM() {
        return new SJSVM(null);
    }

    private void runSJS(ShellArgs options) {
        SJSVM svm = (SJSVM)this.getSVM();
        this.console = new JavaConsole();
        this.monitor = new SJSInterpreterMonitor(this);
        this.console.addActionListener(this.monitor);
        svm.setConsole(this.console);
        new Package_core().init(svm);
        this.parser = new SJSParser();
        SJSCompiler compiler = new SJSCompiler(svm, this.parser, null);
        SVMModule module = new SVMModule("[empty]");
        CodeVector cv = new CodeVector();
        String title = "Untitled";
        String sjsSource = "";
        boolean merge = options.isOptionSpecified("-c") || options.isOptionSpecified("-j") || options.isOptionSpecified("-l") || options.isOptionSpecified("-x");
        String[] files = options.getFiles();
        TreeSet<String> sourceLibraries = new TreeSet<String>();
        int i = 0;
        while (i < files.length) {
            String filename = FileLib.defaultExtension(files[i], ".sjs");
            BufferedReader rd = FileLib.openOnPath(PROGRAM_PATH, filename);
            if (rd == null) {
                filename = FileLib.defaultExtension(files[i], ".js");
                rd = FileLib.openOnPath(PROGRAM_PATH, filename);
            }
            if (rd == null) {
                System.err.println("No file named " + files[i]);
            } else {
                if (title.equals("Untitled")) {
                    title = FileLib.getRoot(FileLib.getTail(filename));
                }
                if (merge) {
                    sjsSource = SJSInterpreter.appendFileToString(rd, sjsSource);
                } else {
                    sjsSource = SJSInterpreter.appendFileToString(rd, "");
                    this.scanForSourceLibraries(sjsSource, this.parser, sourceLibraries);
                    cv = new CodeVector();
                    svm.setSource(sjsSource);
                    this.parser.setInput(svm.getSource());
                    module = this.parser.readModule(filename);
                    module.setSourceText(svm.getSource());
                    compiler.compileModule(module, cv, null);
                    for (String name : module.getImports()) {
                        if (SJSInterpreter.isSourceLibrary(name) || librariesLoaded.contains(name)) continue;
                        JSPackage.load("edu.stanford.cs.sjslib." + name, (Object)svm);
                        librariesLoaded.add(name);
                    }
                    svm.setCode(cv.getCode());
                    svm.setPC(0);
                    svm.run();
                }
                try {
                    rd.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++i;
        }
        try {
            if (merge) {
                if (sjsSource.length() != 0) {
                    sjsSource = this.addSourceLibraries(sjsSource, sourceLibraries);
                    svm.setSource(sjsSource);
                    this.parser.setInput(sjsSource);
                    module = this.parser.readModule("[merged]");
                    compiler.compileModule(module, cv, module.getMainFunction());
                }
            } else {
                this.compileSourceLibraries(compiler, sourceLibraries);
            }
        }
        catch (RuntimeException ex) {
            SJSInterpreter.showError(ex, svm, this.parser.getPosition());
        }
        if (merge) {
            if (options.isOptionSpecified("-x")) {
                SJSInterpreter.exportAsJS(title, module);
            } else {
                cv.addInstruction(0, 0);
                int[] code = cv.getCode();
                if (options.isOptionSpecified("-c")) {
                    this.exportAsSVM(title, code, module);
                } else if (options.isOptionSpecified("-j")) {
                    System.out.println("   private static int[] PROGRAM = {");
                    int n = code.length;
                    int j = 0;
                    while (j < n) {
                        System.out.print("      " + code[j]);
                        System.out.println(j < n - 1 ? "," : "");
                        ++j;
                    }
                    System.out.println("   };");
                } else if (options.isOptionSpecified("-l")) {
                    svm.setCode(code);
                    svm.list();
                }
            }
        } else {
            try {
                svm.setTraceFlag(options.isOptionSpecified("-t"));
                svm.setTraceErrors(options.isOptionSpecified("-e"));
                if (module.hasImport("graphics")) {
                    JSEvent.setHeadlessTimer(false);
                }
                svm.setGlobal("TITLE", Value.createString(title));
                String main = module.getMainFunction();
                if (options.isOptionSpecified("-i")) {
                    main = null;
                }
                if (options.isOptionSpecified("-script")) {
                    main = null;
                }
                if (main != null) {
                    cv = new CodeVector();
                    cv.addInstruction(108, cv.stringRef(main));
                    cv.addInstruction(98, 0);
                    cv.addInstruction(0, 0);
                    svm.setCode(cv.getCode());
                    svm.setGlobal("$MainProgram", Value.createString(main));
                    svm.setPC(0);
                    svm.run();
                    this.monitor.waitForCompletion();
                }
                if (svm.getState() != 7) {
                    this.repl = new SJSReadEvalPrintLoop(svm, this.parser, this.monitor);
                    if (options.isOptionSpecified("-script")) {
                        this.processScript(options.getOption("-script"));
                    }
                    if (options.isOptionSpecified("-i")) {
                        this.monitor.setInteractive(true);
                        this.console.requestInput("> ");
                        this.monitor.waitForExit();
                    }
                }
            }
            catch (RuntimeException ex) {
                SJSInterpreter.showError(ex, svm, svm.getStatementOffset());
            }
        }
    }

    public void processScript(String filename) {
        try {
            String line;
            BufferedReader rd = new BufferedReader(new FileReader(filename));
            while ((line = rd.readLine()) != null) {
                this.console.println("> " + line);
                if (line.equals("")) continue;
                this.repl.processConsoleLine(line);
                this.monitor.waitForCompletion();
            }
            rd.close();
        }
        catch (IOException ex) {
            System.err.println("Error: " + ex.getMessage());
        }
    }

    public void processConsoleLine(String line) {
        if (line.equals("quit")) {
            System.exit(0);
        }
        if (!line.equals("")) {
            this.repl.processConsoleLine(line);
        }
    }

    public void signalFinished() {
        if (this.svm.isFinished()) {
            this.console.requestInput("> ");
        }
    }

    private void scanForSourceLibraries(String source, SJSParser parser, TreeSet<String> sourceLibraries) {
        boolean changed = true;
        while (changed) {
            String[] lines;
            changed = false;
            String[] stringArray = lines = JSPlatform.splitLines(source);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith("import ")) {
                    parser.setInput(line);
                    parser.verifyToken("import");
                    String token = parser.nextToken();
                    if (parser.getTokenType(token) != 3) {
                        throw new SyntaxError("Illegal import statement");
                    }
                    parser.verifyToken(";");
                    String filename = parser.getStringValue(token);
                    if (SJSInterpreter.isSourceLibrary(filename) && !sourceLibraries.contains(filename)) {
                        sourceLibraries.add(filename);
                        changed = true;
                    }
                }
                ++n2;
            }
        }
    }

    private String addSourceLibraries(String sjsSource, TreeSet<String> sourceLibraries) {
        for (String filename : sourceLibraries) {
            BufferedReader rd = FileLib.openOnPath(PROGRAM_PATH, filename);
            if (rd == null) {
                System.err.println("No file named " + filename);
            } else {
                sjsSource = SJSInterpreter.appendFileToString(rd, sjsSource);
            }
            try {
                rd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sjsSource;
    }

    private void compileSourceLibraries(SJSCompiler compiler, TreeSet<String> sourceLibraries) {
        SVM svm = compiler.getSVM();
        SJSParser parser = compiler.getParser();
        for (String filename : sourceLibraries) {
            BufferedReader rd = FileLib.openOnPath(PROGRAM_PATH, filename);
            if (rd == null) {
                System.err.println("No file named " + filename);
            } else {
                String sjsSource = SJSInterpreter.appendFileToString(rd, "");
                CodeVector cv = new CodeVector();
                svm.setSource(sjsSource);
                parser.setInput(svm.getSource());
                SVMModule module = parser.readModule(filename);
                compiler.compileModule(module, cv, null);
                svm.setCode(cv.getCode());
                svm.setPC(0);
                svm.run();
            }
            try {
                rd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean isSourceLibrary(String filename) {
        return filename.endsWith(".js") || filename.endsWith(".sjs");
    }

    private static String appendFileToString(BufferedReader rd, String str) {
        try {
            String line;
            while ((line = rd.readLine()) != null) {
                str = String.valueOf(str) + line + "\n";
            }
            rd.close();
            return str;
        }
        catch (IOException ex) {
            throw new SyntaxError(ex.toString());
        }
    }

    public static void exportAsJS(String name, SVMModule module) {
        FileLib.createDirectory(name);
        SJSInterpreter.createJSFile(name, module.getSourceText(), module);
        SJSInterpreter.createJSDirectory(name, module.getClass().getClassLoader());
        SJSInterpreter.createHTMLIndex(name, module);
    }

    private static void createJSFile(String name, String source, SVMModule module) {
        PrintWriter wr = FileLib.openWriter(String.valueOf(name) + "/" + FileLib.getTail(name) + ".js");
        String[] stringArray = REQUIREJS_HEADER;
        int n = REQUIREJS_HEADER.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            wr.println(line);
            ++n2;
        }
        TreeSet<String> libraries = new TreeSet<String>();
        SJSInterpreter.addImports(libraries, "edu.stanford.cs.sjslib.core");
        for (String str : module.getImports()) {
            if (SJSInterpreter.isSourceLibrary(name)) continue;
            SJSInterpreter.addImports(libraries, "edu.stanford.cs.sjslib." + str);
        }
        boolean first = true;
        wr.print("requirejs([ ");
        for (String lib : libraries) {
            if (first) {
                first = false;
            } else {
                wr.println(",");
                wr.print("            ");
            }
            wr.print(String.valueOf('\"') + lib.replace(".", "/") + '\"');
        }
        wr.println(" ],");
        wr.println();
        first = true;
        wr.print("function(");
        for (String lib : libraries) {
            if (first) {
                first = false;
            } else {
                wr.println(",");
                wr.print("         ");
            }
            wr.print(lib.replace(".", "_"));
        }
        wr.println(") {");
        SJSInterpreter.dumpJSWrapper(wr, "edu.stanford.cs.sjslib.core");
        for (String str : module.getImports()) {
            if (SJSInterpreter.isSourceLibrary(name)) continue;
            SJSInterpreter.dumpJSWrapper(wr, "edu.stanford.cs.sjslib." + str);
        }
        wr.println();
        SJSInterpreter.copyJSSource(wr, JSPlatform.splitLines(source));
        String main = module.getMainFunction();
        if (main != null) {
            wr.println();
            wr.println(String.valueOf(main) + "();");
        }
        wr.println();
        wr.println("});");
        wr.close();
    }

    private static void copyJSSource(PrintWriter wr, String[] lines) {
        int nLines = lines.length;
        int i = 0;
        while (i < nLines) {
            String line = SJSInterpreter.toStandardJavaScript(lines[i]);
            if (line != null) {
                wr.println(line);
            }
            ++i;
        }
    }

    private static String toStandardJavaScript(String line) {
        String trimmed = line.trim();
        if (trimmed.startsWith("import ")) {
            return null;
        }
        if (trimmed.startsWith("const ")) {
            int start = line.indexOf("const ");
            return String.valueOf(line.substring(0, start)) + "var " + line.substring(start + 6);
        }
        return line;
    }

    private static void addImports(TreeSet<String> libraries, String name) {
        SVMPackage pkg = (SVMPackage)JSPackage.load(name, null);
        String[] imports = pkg.getDependencies();
        int n = imports.length;
        int i = 0;
        while (i < n) {
            libraries.add(imports[i]);
            ++i;
        }
    }

    private static void dumpJSWrapper(PrintWriter wr, String name) {
        SVMPackage pkg = (SVMPackage)JSPackage.load(name, null);
        String[] importCode = pkg.getWrapper();
        int nLines = importCode.length;
        int i = 0;
        while (i < nLines) {
            wr.println(importCode[i]);
            ++i;
        }
    }

    public void exportAsSVM(String name, int[] code, SVMModule module) {
        FileLib.createDirectory(name);
        this.createSVMFile(name, code, module);
        SJSInterpreter.createJSDirectory(name, module.getClass().getClassLoader());
        SJSInterpreter.createHTMLIndex(name, module);
    }

    private void createSVMFile(String name, int[] code, SVMModule module) {
        PrintWriter wr = FileLib.openWriter(String.valueOf(name) + "/" + name + ".js");
        String[] stringArray = REQUIREJS_HEADER;
        int n = REQUIREJS_HEADER.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            wr.println(line);
            ++n2;
        }
        wr.println("requirejs([ \"edu/stanford/cs/svm\",");
        wr.print("            \"edu/stanford/cs/sjslib/core\"");
        for (String pkg : module.getImports()) {
            if (SJSInterpreter.isSourceLibrary(name)) continue;
            wr.println(",");
            wr.print("            \"edu/stanford/cs/sjslib/" + pkg + "\"");
        }
        wr.println(" ],");
        wr.println();
        wr.println("function(edu_stanford_cs_svm,");
        wr.print("         edu_stanford_cs_sjslib_core");
        for (String pkg : module.getImports()) {
            if (SJSInterpreter.isSourceLibrary(name)) continue;
            wr.println(", ");
            wr.print("         edu_stanford_cs_sjslib_" + pkg);
        }
        wr.println(") {");
        wr.println("             var pgm = new edu_stanford_cs_svm.SVMConsoleProgram();");
        wr.println("             var svm = pgm.getSVM();");
        wr.println("             new edu_stanford_cs_sjslib_core.Package_core().init(svm);");
        for (String pkg : module.getImports()) {
            if (SJSInterpreter.isSourceLibrary(name)) continue;
            String suffix = pkg.substring(pkg.lastIndexOf(".") + 1);
            String className = "edu_stanford_cs_sjslib_" + pkg + ".Package_" + suffix;
            wr.println("             new " + className + "().init(svm);");
        }
        wr.println("             pgm.setCode([");
        int i = 0;
        while (i < code.length) {
            String sep = i < code.length - 1 ? "," : "";
            wr.println("                " + code[i] + sep);
            ++i;
        }
        wr.println("             ]);");
        wr.println("             pgm.getSVM().run();");
        stringArray = REQUIREJS_TRAILER;
        n = REQUIREJS_TRAILER.length;
        int n3 = 0;
        while (n3 < n) {
            String line = stringArray[n3];
            wr.println(line);
            ++n3;
        }
        wr.close();
    }

    private static void createJSDirectory(String path, ClassLoader cl) {
        try {
            String home = System.getProperty("user.home");
            if (new File(String.valueOf(home) + "/lib/js").exists()) {
                String cmd = "ln -s " + home + "/lib/js " + path;
                Process p = Runtime.getRuntime().exec(cmd);
                p.waitFor();
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    private static void createHTMLIndex(String name, SVMModule module) {
        int width = 500;
        int height = 300;
        PrintWriter wr = FileLib.openWriter(String.valueOf(name) + "/index.html");
        wr.println("<!DOCTYPE html>");
        wr.println("<html core=\"en\">");
        wr.println("<head>");
        wr.println("<title>" + name + "</title>");
        wr.println("<style type=\"text/css\" media=\"screen\">");
        if (module.hasImport("graphics")) {
            width = SJSInterpreter.getGlobalInteger("GWINDOW_WIDTH", width, module);
            height = SJSInterpreter.getGlobalInteger("GWINDOW_HEIGHT", height, module);
            wr.println("  #canvas {");
            wr.println("    overflow: hide;");
            wr.println("    border: solid 1px black;");
            wr.println("    background-color: white;");
            wr.println("    width: " + width + "px;");
            wr.println("    height: " + height + "px;");
            wr.println("  }");
        } else if (SJSInterpreter.usesConsole(module)) {
            width = SJSInterpreter.getGlobalInteger("CONSOLE_WIDTH", width, module);
            height = SJSInterpreter.getGlobalInteger("CONSOLE_HEIGHT", height, module);
        }
        if (SJSInterpreter.usesConsole(module)) {
            if (module.hasImport("graphics")) {
                height = 200;
            }
            wr.println("  #console {");
            wr.println("    overflow: hide;");
            wr.println("    border: solid 1px black;");
            wr.println("    background-color: white;");
            wr.println("    width: " + width + "px;");
            wr.println("    height: " + height + "px;");
            wr.println("  }");
        }
        wr.println("</style>");
        wr.println("</head>");
        wr.println("<body>");
        if (module.hasImport("graphics")) {
            wr.println("<div id=\"canvas\"></div>");
            if (SJSInterpreter.usesConsole(module)) {
                wr.println("<p>");
            }
        }
        if (SJSInterpreter.usesConsole(module)) {
            wr.println("<div id=\"console\"></div>");
        }
        wr.println("<script data-main=\"" + FileLib.getTail(name) + ".js\"" + " src=\"js/requirejs/require.js\"></script>");
        wr.println("</body>");
        wr.println("</html>");
        wr.close();
    }

    private static boolean usesConsole(SVMModule module) {
        return false;
    }

    private static int getGlobalInteger(String name, int defValue, SVMModule module) {
        for (Expression declaration : module.getGlobals()) {
            Value value;
            Expression exp = declaration.getArgs()[0];
            if (!exp.getArgs()[0].getName().equals(name)) continue;
            Expression rhs = exp.getArgs()[1];
            if (rhs.getType() == 1 && (value = rhs.getValue()).isIntegral()) {
                return value.getIntegerValue();
            }
            return defValue;
        }
        return defValue;
    }
}

