/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjs;

import edu.stanford.cs.java2js.JSEvent;
import edu.stanford.cs.java2js.JSFile;
import edu.stanford.cs.java2js.JSFileChooser;
import edu.stanford.cs.sjs.SJS;
import edu.stanford.cs.sjs.SJSEditor;
import edu.stanford.cs.sjs.SJSInterpreter;
import edu.stanford.cs.sjs.SJSSaveFileListener;
import edu.stanford.cs.svm.SVMModule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class SJSSaveListener
implements ActionListener {
    private JSFileChooser chooser;
    private SJS app;

    public SJSSaveListener(SJS app, JSFileChooser chooser) {
        this.app = app;
        this.chooser = chooser;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!JSEvent.isErrorEvent(e)) {
            SVMModule module;
            if (this.chooser.getDialogTitle().equals("Save")) {
                String path = this.chooser.getPath();
                if (path != null && path.length() != 0) {
                    SJSEditor editor = this.app.getActiveEditor();
                    String text = editor.getText();
                    new JSFile(path).write(text, new SJSSaveFileListener(this.app, path));
                }
            } else if (this.chooser.getDialogTitle().equals("Export") && (module = this.app.getModule()) != null) {
                SJSInterpreter.exportAsJS(this.chooser.getPath(), module);
            }
        }
    }
}

