/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjs;

import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.parser.Parser;
import edu.stanford.cs.parser.Statement;
import edu.stanford.cs.parser.SyntaxError;
import edu.stanford.cs.sjs.SJSParser;
import java.util.ArrayList;

public class SJSSwitchStatement
extends Statement {
    @Override
    public Expression prefixAction(Parser p) {
        SJSParser jsp = (SJSParser)p;
        ArrayList<Expression> body = new ArrayList<Expression>();
        jsp.verifyToken("(");
        body.add(jsp.readE(0));
        jsp.verifyToken(")");
        jsp.verifyToken("{");
        String token = jsp.nextToken();
        if (!token.equals("}")) {
            boolean started = false;
            do {
                if (token.equals("case")) {
                    body.add(this.readCaseClause(jsp));
                    started = true;
                    continue;
                }
                if (token.equals("default")) {
                    body.add(this.readDefaultClause(jsp));
                    started = true;
                    continue;
                }
                if (!started) {
                    throw new SyntaxError("Missing " + p.markCode("case") + " clause");
                }
                jsp.saveToken(token);
                body.add(jsp.readStatement());
            } while (!(token = jsp.nextToken()).equals("}"));
        }
        int n = body.size();
        Expression[] array = new Expression[n];
        int i = 0;
        while (i < n) {
            array[i] = (Expression)body.get(i);
            ++i;
        }
        return jsp.createCompound(this, array);
    }

    @Override
    public void compile(Parser p, Expression[] args, CodeVector cv) {
        SJSParser jsp = (SJSParser)p;
        String exit = cv.newLabel();
        jsp.pushStatementContext(exit, null);
        jsp.compile(args[0], cv);
        String temp = "v_" + jsp.getStatementDepth();
        cv.addInstruction(104, cv.stringRef(temp));
        cv.addInstruction(109, cv.stringRef(temp));
        int i = 1;
        while (i < args.length) {
            jsp.compile(args[i], cv);
            ++i;
        }
        String tag = jsp.getNextLabel();
        if (tag != null) {
            cv.defineLabel(tag);
        }
        cv.defineLabel(exit);
        jsp.popStatementContext();
    }

    private Expression readCaseClause(Parser p) {
        Expression exp = p.readE(0);
        p.verifyToken(":");
        return p.createCompound1(p.getOperator("case"), exp);
    }

    private Expression readDefaultClause(Parser p) {
        p.verifyToken(":");
        return p.createCompound0(p.getOperator("default"));
    }
}

