/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjslib.graphics;

import edu.stanford.cs.exp.Value;
import edu.stanford.cs.graphics.GImage;
import edu.stanford.cs.sjslib.graphics.GImageMethod;
import edu.stanford.cs.svm.SVM;

class GImage_xgs
extends GImageMethod {
    GImage_xgs() {
    }

    @Override
    public void execute(SVM svm, Value receiver) {
        svm.checkSignature("GImage.xgs", "*");
        GImage image = (GImage)svm.pop().getValue();
        int[][] array = image.getPixelArray();
        int height = array.length;
        int width = array[0].length;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int xx = this.computeLuminosity(array[i][j]);
                array[i][j] = GImage.createRGBPixel(xx, xx, xx);
                ++j;
            }
            ++i;
        }
        svm.push(Value.createObject(new GImage(array), "GImage"));
    }

    private int computeLuminosity(int pixel) {
        int r = GImage.getRed(pixel);
        int g = GImage.getGreen(pixel);
        int b = GImage.getBlue(pixel);
        return (int)Math.floor(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b + 0.5);
    }
}

