/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.exp.Value;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMInstruction;

abstract class ArithmeticOp
extends SVMInstruction {
    public ArithmeticOp(String name, int code) {
        super(name, code);
    }

    @Override
    public void execute(SVM svm, int addr) {
        Value rhs = svm.pop();
        Value lhs = svm.pop();
        if (!lhs.isNumeric() || !rhs.isNumeric()) {
            throw new RuntimeException("Illegal to apply " + this.getName() + " to " + lhs + " and " + rhs);
        }
        if (lhs.getType() == 73 && rhs.getType() == 73) {
            int x = lhs.getIntegerValue();
            int y = rhs.getIntegerValue();
            svm.pushInteger(this.applyInteger(x, y));
        } else {
            double x = lhs.getDoubleValue();
            double y = rhs.getDoubleValue();
            svm.pushDouble(this.applyDouble(x, y));
        }
    }

    public abstract int applyInteger(int var1, int var2);

    public abstract double applyDouble(double var1, double var3);
}

