/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.exp.Value;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMInstruction;

class DIV_Ins
extends SVMInstruction {
    public DIV_Ins() {
        super("DIV", 35);
    }

    @Override
    public void execute(SVM svm, int addr) {
        Value rhs = svm.pop();
        Value lhs = svm.pop();
        if (!lhs.isNumeric() || !rhs.isNumeric()) {
            throw new RuntimeException("Illegal to apply " + this.getName() + " to " + lhs + " and " + rhs);
        }
        if (lhs.getType() == 73 && rhs.getType() == 73) {
            int num = lhs.getIntegerValue();
            int den = rhs.getIntegerValue();
            if (den != 0 && num / den * den == num) {
                svm.pushInteger(num / den);
            } else {
                svm.pushDouble((double)num / (double)den);
            }
        } else {
            svm.pushDouble(lhs.getDoubleValue() / rhs.getDoubleValue());
        }
    }
}

