/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.parser.SyntaxError;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMInstruction;
import edu.stanford.cs.tokenscanner.TokenScanner;

abstract class SVMOffsetInstruction
extends SVMInstruction {
    public SVMOffsetInstruction(String name, int code) {
        super(name, code);
    }

    @Override
    public void assemble(CodeVector cv, TokenScanner scanner) {
        String token = scanner.nextToken();
        int type = scanner.getTokenType(token);
        switch (type) {
            case 2: {
                cv.addWord(this.getCode() << 24 | Integer.parseInt(token));
                break;
            }
            case 1: {
                cv.addWord(this.getCode() << 24 | cv.getLabel(token));
                break;
            }
            default: {
                throw new SyntaxError("Illegal argument " + token);
            }
        }
    }

    @Override
    public String unparse(SVM svm, int addr) {
        return String.valueOf(this.getName()) + " " + addr;
    }
}

