/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.unittest;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UnitTest {
    private static String[] METHODS = new String[]{"showErrorMessage", "println"};
    private static double RADIUS = 1.0E-15;
    private static int errorCount = 0;
    private static Method showErrorMessage = null;

    public static void assertTrue(String msg, boolean exp) {
        if (!exp) {
            ++errorCount;
            if (showErrorMessage == null) {
                System.err.println(msg);
            } else {
                try {
                    Object[] args = new Object[]{msg};
                    showErrorMessage.invoke((Object)args, new Object[0]);
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex.toString());
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex.toString());
                }
            }
        }
    }

    public static void assertTrue(boolean exp) {
        UnitTest.assertTrue("Failure: " + exp + " != true", exp);
    }

    public static void assertFalse(String msg, boolean exp) {
        UnitTest.assertTrue(msg, !exp);
    }

    public static void assertFalse(boolean exp) {
        UnitTest.assertFalse("Failure: " + exp + " != false", exp);
    }

    public static void assertEquals(String msg, Object exp1, Object exp2) {
        if (exp1 == null || exp2 == null) {
            UnitTest.assertTrue(msg, exp1 == exp2);
        } else if (exp1 instanceof Double && exp2 instanceof Number || exp1 instanceof Number && exp2 instanceof Double) {
            double d1 = ((Number)exp1).doubleValue();
            double d2 = ((Number)exp2).doubleValue();
            double r = Math.max(Math.abs(d1), Math.abs(d2)) * RADIUS;
            UnitTest.assertTrue(msg, Math.abs(d1 - d2) <= r);
        } else {
            UnitTest.assertTrue(msg, exp1 == null ? exp2 == null : exp1.equals(exp2));
        }
    }

    public static void assertEquals(Object exp1, Object exp2) {
        UnitTest.assertEquals("Failure: " + exp1 + " !== " + exp2, exp1, exp2);
    }

    public static void assertNotEquals(String msg, Object exp1, Object exp2) {
        if (exp1 == null || exp2 == null) {
            UnitTest.assertFalse(msg, exp1 == exp2);
        } else if (exp1 instanceof Double && exp2 instanceof Number || exp1 instanceof Number && exp2 instanceof Double) {
            double d1 = ((Number)exp1).doubleValue();
            double d2 = ((Number)exp2).doubleValue();
            double r = Math.max(Math.abs(d1), Math.abs(d2)) * RADIUS;
            UnitTest.assertFalse(msg, Math.abs(d1 - d2) <= r);
        } else {
            UnitTest.assertFalse(msg, exp1 == null ? exp2 == null : exp1.equals(exp2));
        }
    }

    public static void assertNotEquals(Object exp1, Object exp2) {
        UnitTest.assertNotEquals("Failure: " + exp1 + " !== " + exp2, exp1, exp2);
    }

    public static void assertNull(String msg, Object exp) {
        UnitTest.assertEquals(msg, exp, null);
    }

    public static void assertNull(Object exp) {
        UnitTest.assertNull("Failure: " + exp + " != null", exp);
    }

    public static void assertNotNull(String msg, Object exp) {
        UnitTest.assertNotEquals(msg, exp, null);
    }

    public static void assertNotNull(Object exp) {
        UnitTest.assertNotNull("Failure: " + exp + " == null", exp);
    }

    public static void assertSame(String msg, Object exp1, Object exp2) {
        UnitTest.assertTrue(msg, exp1 == exp2);
    }

    public static void assertSame(Object exp1, Object exp2) {
        UnitTest.assertSame("Failure: " + exp1 + " != " + exp2, exp1, exp2);
    }

    public static void assertNotSame(String msg, Object exp1, Object exp2) {
        UnitTest.assertTrue(msg, exp1 != exp2);
    }

    public static void assertNotSame(Object exp1, Object exp2) {
        UnitTest.assertNotSame("Failure: " + exp1 + " == " + exp2, exp1, exp2);
    }

    public static void resetErrorCount() {
        errorCount = 0;
    }

    public static int getErrorCount() {
        return errorCount;
    }

    public static void setConsole(Object console) {
        if (console == null) {
            showErrorMessage = null;
            return;
        }
        String[] stringArray = METHODS;
        if (METHODS.length != 0) {
            String m = stringArray[0];
            try {
                Class[] types = new Class[]{String.class};
                showErrorMessage = console.getClass().getMethod(m, types);
                return;
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("No showErrorMessage method");
            }
        }
    }
}

