import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

# Define the function
def f(x, y):
    term1 = (4 - np.sqrt(x**2 + y**2))**2 / 2
    term2 = ((x - 3)**2 + (y - 3)**2) / 8
    return np.exp(- (term1 + term2))

# Define grid with higher resolution
x = np.linspace(-10, 10, 100)  # Increased resolution

y = np.linspace(-10, 10, 100)  # Increased resolution
X, Y = np.meshgrid(x, y)
Z = f(X, Y)

# Create interactive 3D plot
fig = plt.figure(figsize=(12, 9))
ax = fig.add_subplot(111, projection='3d')
ax.plot_surface(X, Y, Z, cmap='jet', edgecolor='k',rstride=1, cstride=1,   linewidth=0, antialiased=False)  # Improved precision
ax.view_init(elev=30, azim=45)  # Set initial view
ax.set_xticks(np.linspace(-5, 10, 10))  # Improve tick spacing
ax.set_yticks(np.linspace(-5, 10, 10))
ax.set_zticks(np.linspace(np.min(Z), np.max(Z), 6))

# Show the plot interactively
plt.show(block=True)
