import random
from scipy import stats
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np
from tqdm import tqdm

def main():
    totals = []
    for i in tqdm(range(10000)):
        total = run_experiment()
        totals.append(total)
    # print(totals)
    plot_totals(totals)

def run_experiment():
    total = 0
    for i in range(100):
        total += stats.poisson.rvs(2)
    return total

def plot_totals(totals):
    ax = sns.histplot(totals, bins=400, binrange= (0, 400))
    plt.show()


if __name__ == '__main__':
    main()