import random
from scipy import stats
import matplotlib.pyplot as plt
import seaborn as sns
import numpy as np
from tqdm import tqdm

def main():
    totals = []
    for i in tqdm(range(100000)):
        total = run_experiment()
        totals.append(total)
    # print(totals)
    plot_totals(totals)

def run_experiment():
    total = 0
    for i in range(50):
        sample = random_roll() 
        total += sample
    return total

def random_roll():
    return random.choice([1,2,3,4,5,6])

def plot_totals(totals):
    ax = sns.histplot(totals, bins=50)
    plt.show()


if __name__ == '__main__':
    main()