import numpy as np

# MLE probabilities for each book
# Order: ratings 1, 2, 3, 4, 5

p1 = np.array([0, 0, 0, 1/5, 4/5])          # Book 1
p2 = np.array([0, 1/223, 2/223, 20/223, 200/223])  # Book 2

prob = 0.0
for i in range(5):         # rating for Book 1 (0-index → rating i+1)
    for j in range(i+1, 5):   # rating for Book 2 strictly greater
        prob += p1[i] * p2[j]

print("P(Book 2 > Book 1) =", prob)