#CBCentralManagerDelegate
#https://developer.apple.com/library/prerelease/ios/documentation/CoreBluetooth/Reference/CBCentralManagerDelegate_Protocol/index.html#//apple_ref/occ/intf/CBCentralManagerDelegate
    def centralManager_didConnectPeripheral_(self, manager, peripheral):
    def centralManager_didDisconnectPeripheral_error_(self, manager, peripheral, error):
    def centralManager_didFailToConnectPeripheral_error_(self, manager, peripheral, error):
    def centralManager_didDiscoverPeripheral_advertisementData_RSSI_(self, manager, peripheral, data, rssi):
    def centralManager_didRetrievePeripherals_(self, manager, peripherals):
    def centralManagerDidUpdateState_(self, manager):

#CBPeripheralDelegate
#https://developer.apple.com/library/prerelease/ios/documentation/CoreBluetooth/Reference/CBPeripheralDelegate_Protocol/index.html#//apple_ref/occ/intf/CBPeripheralDelegate
    def peripheral_didDiscoverServices_(self, peripheral, error):
    def peripheral_didDiscoverCharacteristicsForService_error_(self, peripheral, service, error):
    def peripheral_didUpdateValueForCharacteristic_error_(self, peripheral, characteristic, error):
    def peripheral_didWriteValueForCharacteristic_error_(self, peripheral, characteristic, error):
    def peripheral_didUpdateNotificationStateForCharacteristic_error_(self, peripheral, characteristic, error):

#CBCentralManager
#https://developer.apple.com/library/prerelease/ios/documentation/CoreBluetooth/Reference/CBCentralManager_Class/index.html#//apple_ref/occ/instp/CBCentralManager/delegate
manager = CBCentralManager.alloc()
manager.initWithDelegate_queue_options_(self, None, None)
manager.connectPeripheral_options_(peripheral, None)
manager.cancelPeripheralConnection_(peripheral)
manager.retrievePeripherals_(self.idListHistory) 
manager.retrievePeripheralsWithIdentifiers_([peripheral.identifier()])
manager.scanForPeripheralsWithServices_options_([Ads], None)
manager.stopScan()
manager.state()
#CBCentralManger::CBCentralManagerState::
CBCentralManagerStateUnknown = 0
CBCentralManagerStateResetting = 1
CBCentralManagerStateUnsupported = 2
CBCentralManagerStateUnauthorized = 3
CBCentralManagerStatePoweredOff = 4
CBCentralManagerStatePoweredOn = 5

#CBPeripheral
#https://developer.apple.com/library/ios/documentation/CoreBluetooth/Reference/CBPeripheral_Class/index.html#//apple_ref/occ/cl/CBPeripheral
peripheral.UUID()
peripheral.identifier()
peripheral.discoverServices_([Name, Info, Sensors, Effectors])
peripheral.services()
peripheral.discoverCharacteristics_forService_([HS_Rx, HS_Tx, Device_name, Manufacturer_name, Model_number, Firmware_revision], service)
peripheral.readValueForCharacteristic_(characteristic)
peripheral.writeValue_forCharacteristic_type_(valData, robot.tx, 1)#CBCharacteristicWriteWithoutResponse)
peripheral.setNotifyValue_forCharacteristic_(True, robot.rx)
peripheral.state()
#CBPeripheral::CBPeripheralState::
CBPeripheralStateDisconnected = 0
CBPeripheralStateConnecting = 1
CBPeripheralStateConnected = 2

peripheral.retain()
peripheral.setDelegate_(self)


#CBCharacteristic
#https://developer.apple.com/library/prerelease/ios/documentation/CoreBluetooth/Reference/CBCharacteristic_Class/index.html#//apple_ref/occ/cl/CBCharacteristic
characteristic.UUID()
characteristic.value()
