'''
/* =======================================================================
   (c) 2015, Kre8 Technology, Inc.

   PROPRIETARY and CONFIDENTIAL
   ========================================================================*/
'''
import sys, os #, getopt
import time  # sleep
import signal
#Bluetooth LE on OS X via Python
import objc
from PyObjCTools import AppHelper
from Cocoa import NSUTF8StringEncoding
objc.loadBundle('CoreBluetooth', globals(),bundle_path=objc.pathForFramework(u'/System/Library/Frameworks/IOBluetooth.framework/Versions/A/Frameworks/CoreBluetooth.framework'))

Ads = CBUUID.UUIDWithString_(u'F138')
Sensors = CBUUID.UUIDWithString_(u'00009001-9C80-11E3-A5E2-0800200C9A66')
Effectors = CBUUID.UUIDWithString_(u'0000a000-9c80-11e3-a5e2-0800200c9a66')
HS_Rx = CBUUID.UUIDWithString_(u'0000900A-9C80-11E3-A5E2-0800200C9A66')
HS_Tx = CBUUID.UUIDWithString_(u'0000a006-9c80-11e3-a5e2-0800200c9a66')

def clean_up():
    print "cleaning up..."
    if (sys.platform == 'darwin'):
       AppHelper.stopEventLoop()

def signal_handler(signal, frame):
    print 'You pressed Ctrl+C!'
    clean_up()

signal.signal(signal.SIGINT, signal_handler)

class RobotDelegate(object): #CentralManger Delegate
    def __init__(self, maxRobotNum = 1, minRSSI = -50):
        print maxRobotNum, minRSSI
        self.minRSSI = minRSSI # minimum RSSI requirement for initial connection
        self.maxRobotNum = maxRobotNum # maximum number of robots
        self.manager = CBCentralManager.alloc()
        self.manager.initWithDelegate_queue_options_(self, None, None) # setting "self(==this)" as the CentralManger Delegate

    def centralManagerDidUpdateState_(self, manager):
        print "central manager started!", manager
        #scan
        self.startScan()

    #discover peripheral
    #connect peripheral only if RSSI > minRSSI --> set peripheral delegate: peripheral.setDelegate_(peripheral_delegate)
    #stop scanning
    #discover services
    #discover charateristics
    #discover descriptors
    #characteristics: read, write, notify
    
    def startScan(self):
        print "startScan()..."
        self.manager.scanForPeripheralsWithServices_options_([Ads], None)

    def stopScan(self):
        print "stopScan()"
        self.manager.stopScan()
        
    def centralManager_didDiscoverPeripheral_advertisementData_RSSI_(self, manager, peripheral, data, rssi):
        if (rssi > self.minRSSI):
            self.stopScan()
            print "new connection:",repr(peripheral), "RSSI:", repr(rssi), "...didDiscoverPeripheral"
            peripheral.retain()
            #manager.connectPeripheral_options_(peripheral, None)
            clean_up() #comment this out in order to continue
        else:
            self.stopScan()            
            print "RSSI = ", rssi," < ", self.minRSSI," dBm. Bring Hamster closer to the BLE source."
            self.startScan()
            #time.sleep(1)

    
def main(argv=None):
    # instantiate COMM object
    comm = RobotDelegate(1, -50)
    print 'Bluetooth API starts'
    
    if (os.name == 'posix' and sys.platform == 'darwin'):
        AppHelper.runConsoleEventLoop() # main thread: infinite loop until appHelper.stopEventLoop() is called.
    else:
        print "Error: Unknown OS"

    time.sleep(1.0)

    print("terminated!")

if __name__ == "__main__":
    sys.exit(main())



