import behavior
import time
import math

class Behavior(behavior.RobotBehavior):
    def __init__(self, name, robotList, sweep_period, queue):
        super(Behavior, self).__init__(name, robotList)
        self._period = sweep_period
        self._queue = queue

    def write_servo_position(self, deg):
        pass #move the servo motor to deg

    def read_psd_distance(self):
        return 100 #read psd distance 

    def behavior_loop(self):
        print self._name, "behavior_loop() starts!"
        dir = 1
        delta = 1
        deg = 0
        line_psd = {}
        for i in range(0, 181):
            line_psd[i] = None
        period = self._period/len(line_psd)*delta
        print "scanning period: 180deg:",period, "sec"
        while (not self._bQuit):
            for robot in self._robotList:
                #print self._name, "behavior_loop(): time = ", time.time(), "sec"

                #move to the desired position: {deg| 0 < deg <=180}
                deg = deg + dir * delta
                offset = 0
                if deg < 0:
                    deg = 0
                    dir = 1
                elif deg > 180 - offset:
                    deg = 180 - offset
                    dir = -1
                self.write_servo_position(deg) #implement

                #read the psd distance value
                deg2 = deg
                if (dir == -1):
                    deg2 = deg + offset
                rad = deg2 * math.pi / 180.0
                psd_value = self.read_psd_distance() #implement
                mag = 255 - psd_value;

                #draw graphics
                elem = {}
                elem[0] = mag
                elem[1] = rad
                elem[2] = deg2
                self._queue.put(elem)

                #analyze the sensor data[1 ... 180]

            time.sleep(period)
        print self._name, "behavior_loop() finished!"

