'''
/* =======================================================================
   (c) 2015, Kre8 Technology, Inc.

   PROPRIETARY and CONFIDENTIAL
   ========================================================================*/
'''
import sys, os #, getopt
import time  # sleep
import signal
import threading
from HamsterAPI.comm_ble import RobotComm

if (sys.platform == 'darwin'):
    from PyObjCTools import AppHelper

gMaxRobotNum = 1; # max number of robots to control
gRobotList = None

def behavior_blink():
    global gRobotList
 
    while not gQuit:
        if (len(gRobotList) > 0):
          for robot in gRobotList:
            robot.set_led(0, 3)
            robot.set_led(1, 3)
            time.sleep(0.1)
            robot.set_led(0, 0)
            robot.set_led(1, 0)
            time.sleep(0.1)
        time.sleep(0.01)
    print "robot stops blinking"
        
def behavior_square():
    global gRobotList
 
    while not gQuit:
        if (len(gRobotList) > 0):
          for robot in gRobotList:
            for i in range(0,3):
                time.sleep(1)
                robot.set_wheel(0, 30)
                robot.set_wheel(1, 30)
                time.sleep(2)
                robot.set_wheel(0, -25)
                robot.set_wheel(1, 25)
                #time.sleep(1)

        time.sleep(0.01)
    print "robot stops moving"

#house keeping
def clean_up():
    print "cleaning up..."
    if (sys.platform == 'darwin'):
       AppHelper.stopEventLoop()

def signal_handler(signal, frame):
    print 'You pressed Ctrl+C!'
    clean_up()

signal.signal(signal.SIGINT, signal_handler)

def main(argv=None):
    # instantiate COMM object
    global gMaxRobotNum
    comm = RobotComm(gMaxRobotNum)
    comm.start()
    print 'Bluetooth starts'
    
    # instanciate Robot
    global gRobotList, gRobotArray
    gRobotList = comm.robotList
    #gRobotArray = comm.robotArray
    global gQuit

    gQuit = False

    # start a behavior tread
    behavior_thread1 = threading.Thread(target=behavior_square)
    behavior_thread1.daemon = True
    behavior_thread1.start()

    # start a behavior tread
    behavior_thread2 = threading.Thread(target=behavior_blink)
    behavior_thread2.daemon = True
    behavior_thread2.start()

    #cleaning up when terminated
    if (sys.platform == 'win32' or os.name == 'nt'):
        os.system("pause")
        pass
    elif os.name == 'posix':
        if (sys.platform == 'darwin'):
            AppHelper.runConsoleEventLoop()
        else:
            while True:
                time.sleep(0.1)
    else:
        print "Error: Unknown OS"

    gQuit = True

    behavior_thread1.join()
    behavior_thread2.join()
    
    for robot in gRobotList:
        robot.reset()
    time.sleep(1.0)
    comm.stop()
    comm.join()



    print("terminated!")

if __name__ == "__main__":
    #sys.exit(main())
    main()