'''
/* =======================================================================
   (c) 2015, Kre8 Technology, Inc.

   PROPRIETARY and CONFIDENTIAL
   ========================================================================*/
'''
import time  # sleep
import Tkinter as tk
import threading
from HamsterAPI.comm_ble import RobotComm

gMaxRobotNum = 1; # max number of robots to control
gRobotList = None

def behavior_blink():
    global gRobotList
 
    while not gQuit:
        if (len(gRobotList) > 0):
          for robot in gRobotList:
            robot.set_led(0, 3)
            robot.set_led(1, 3)
            time.sleep(0.1)
            robot.set_led(0, 0)
            robot.set_led(1, 0)
            time.sleep(0.1)
        time.sleep(0.01)
    print "robot stops blinking"
        
def behavior_square():
    global gRobotList
 
    while not gQuit:
        if (len(gRobotList) > 0):
          for robot in gRobotList:
            for i in range(0,3):
                time.sleep(1)
                robot.set_wheel(0, 30)
                robot.set_wheel(1, 30)
                time.sleep(1.6)
                robot.set_wheel(0, -25)
                robot.set_wheel(1, 25)
                #time.sleep(1)

        time.sleep(0.01)
    print "robot stops moving"


def Square(event=None):
    global behavior_thread1
    
    if (len(gRobotList) > 0):
        print "move in a square"
        # start a behavior tread
        behavior_thread1 = threading.Thread(target=behavior_square)
        behavior_thread1.daemon = True
        behavior_thread1.start()
    else:
        print "waiting for robot"


def Blink(event=None):
    global behavior_thread2

    if (len(gRobotList) > 0):
        print "blink"
        # start a behavior tread
        behavior_thread2 = threading.Thread(target=behavior_blink)
        behavior_thread2.daemon = True
        behavior_thread2.start()
    else:
        print "waiting for robot"

def stopProg(event=None):
    frame.quit()
    print "Exit"

def main(argv=None):
    # instantiate COMM object
    global gMaxRobotNum
    global frame
    global behavior_thread1, behavior_thread2
    global gRobotList
    global gQuit

    comm = RobotComm(gMaxRobotNum)
    comm.start()
    print 'Bluetooth starts'
    
    gRobotList = comm.robotList
    #gRobotArray = comm.robotArray


    gQuit = False
    behavior_thread1 = behavior_thread2 = False

    frame = tk.Tk()
    canvas = tk.Canvas(frame, bg="white", width=300, height=300)
    canvas.pack(expand=1, fill='both')
    canvas.create_rectangle(175, 175, 125, 125, fill="green")
 
    button1 = tk.Button(frame,text="Square")
    button1.pack()
    button1.bind('<Button-1>', Square)
 
    button2 = tk.Button(frame,text="Blink")
    button2.pack()
    button2.bind('<Button-1>', Blink)

    button3 = tk.Button(frame,text="Exit")
    button3.pack()
    button3.bind('<Button-1>', stopProg)


    frame.mainloop()
    
    print "Cleaning up"
    gQuit = True
    if behavior_thread1:
        behavior_thread1.join()
    if behavior_thread2:
        behavior_thread2.join()

    for robot in gRobotList:
      robot.reset()
    time.sleep(1.0)
    comm.stop()
    comm.join()

    print("terminated!")


if __name__ == "__main__":
    #sys.exit(main())
    main()