import Tkinter as tk  # using Python 3
import time  # sleep
from HamsterAPI.comm_ble import RobotComm
#for PC, need to import from commm_usb


gMaxRobotNum = 1; # max number of robots to control
gRobotList = None

def move_up(event=None):
    for robot in gRobotList:
        robot.set_wheel(0,30)
        robot.set_wheel(1,30)

def move_down(event=None):
    for robot in gRobotList:
        robot.set_wheel(0,-30)
        robot.set_wheel(1,-30)

def move_left(event=None):
    for robot in gRobotList:
        robot.set_wheel(0,30)
        robot.set_wheel(1,-30)

def move_right(event=None):
    for robot in gRobotList:
        robot.set_wheel(0,-30)
        robot.set_wheel(1,30)

def stop_move(event=None):
    for robot in gRobotList:
        robot.set_wheel(0,0)
        robot.set_wheel(1,0)

def stopProg(event=None):
    m.quit()
    print "Exit"

if __name__== "__main__":
    comm = RobotComm(gMaxRobotNum)
    comm.start()
    print 'Bluetooth starts'

    gRobotList = comm.robotList

    m = tk.Tk() #root

    canvas = tk.Canvas(m, bg="white", width=300, height= 300)
    canvas.pack()
    x1, x2 = 125, 175
    y1, y2 = 125, 175
    rect = (x1, y1, x2, y2)
    rect_id = canvas.create_rectangle(rect, fill='blue')
    canvas.bind_all('<w>', move_up)  
    canvas.bind_all('<s>', move_down)  
    canvas.bind_all('<a>', move_left)  
    canvas.bind_all('<d>', move_right)
    canvas.bind_all('<x>', stop_move)  

    button = tk.Button(m,text="Exit")
    button.pack()
    button.bind('<Button-1>', stopProg)

    m.mainloop()


    for robot in gRobotList:

        robot.reset()



    comm.stop()

    comm.join()