﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using OpenMetaverse;

using CS422API;

namespace CS422API
{
    /// <summary>
    /// This class contains a bunch of examples of how to use the methods in the API.
    /// Uncomment the appropriate section in Main() to run the example.
    /// </summary>
    class Examples
    {
        static void Main(string[] args)
        {
            //////////////////////////////
            // getAvatars() example
            //////////////////////////////

            //Vector3 location = new Vector3(258877, 253512, 106);
            //string startString = "2010-02-22 18:47:52";
            //string endString = "2010-02-22 20:47:52";
            //DateTime start = DateTime.Parse(startString);
            //DateTime end = DateTime.Parse(endString);

            //UUID[] uuids = API.getAvatars(location, start, end);
            //Console.WriteLine("We saw the following avatars at location " + location + " between "
            //    + startString + " and " + endString + ":");
            //foreach (UUID uuid in uuids)
            //{
            //    Console.WriteLine(uuid);
            //}
            

            //////////////////////////////
            // getChats() example
            //////////////////////////////

            //string startString = "2010-03-11 18:47:52";
            //string endString = "2010-03-11 22:47:52";
            //DateTime start = DateTime.Parse(startString);
            //DateTime end = DateTime.Parse(endString);
            //UUID orion = new UUID("57186b55-f230-4063-aabf-ba14b50f2e6f");
            //ChatEvent[] chats = API.getChats(orion, start, end);
            //Console.WriteLine("Avatar " + orion + " was involved with the following chats between " 
            //    + startString + " and " + endString + ":");
            //foreach (ChatEvent c in chats)
            //{
            //    Console.WriteLine(c.speaker + " to " + c.listener + ": ");
            //    Console.WriteLine("    " + c.message);
            //}

            //////////////////////////////
            // getPlaces() example
            //////////////////////////////

            //string startString = "2010-03-05 18:47:52";
            //string endString = "2010-03-11 22:47:52";
            //DateTime start = DateTime.Parse(startString);
            //DateTime end = DateTime.Parse(endString);
            //UUID avatar = new UUID("57186b55-f230-4063-aabf-ba14b50f2e6f");
            //Vector3[] places = API.getPlaces(avatar, start, end, API.Ordering.Latest);
            //Console.WriteLine("Avatar " + avatar + " was at the following places between "
            //    + startString + " and " + endString + ":");          
            //foreach (Vector3 v in places)
            //{
            //    Console.WriteLine(v);
            //}

            //////////////////////////////
            // getMeetings() example
            //////////////////////////////

            string startString = "2010-03-30 00:47:52";
            string endString = "2010-03-30 22:47:52";
            DateTime start = DateTime.Parse(startString);
            DateTime end = DateTime.Parse(endString);
            UUID avatar1 = new UUID("32ceced1-58e1-4394-aa09-80f84f2fe9ce");
            UUID avatar2 = new UUID("10e43fbd-65af-487e-a0ff-dbf05fab5636");
            UUID[] avatars = new UUID[] { avatar1, avatar2 };
            Meeting[] meetings = API.getMeetings(avatars, start, end);
            Console.WriteLine("The following avatars:");
            foreach (UUID uuid in avatars)
            {
                Console.WriteLine("   " + uuid);
            }
            Console.WriteLine("had these meetings between " + startString + " and " + endString + ":");
            foreach (Meeting m in meetings)
            {
                Console.WriteLine("Location = " + m.location + " from " + m.start + " to " + m.end);
            }

            //////////////////////////////
            // Leave the following uncommented
            //////////////////////////////

            // Leave this in, otherwise terminal window will disappear immediately after starting
            Console.Read();
        }
    }
}
