﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Timers;

using OpenMetaverse;

namespace CS422API
{
    class Follow
    {
        public static GridClient client = new GridClient();

        // Use your dummy stalker avatar's name and password here
        private static string stalkerFirstName = "STALKER FIRST NAME";
        private static string stalkerLastName = "STALKER LAST NAME ";
        private static string stalkerPassword = "STALKER PASSWORD";

        // Set the avatar you wish to target here
        private static string targetName = "Raymond Reynaud";

        // How far, in meters, the target can go before we start moving
        private static float followDistance = 0;

        public static void Main2(string[] args)
        {
            // Callback for sims object update event, this is where we grab the coordinates. 
            client.Objects.OnObjectUpdated += CodeFollow;

            // Set our appearance to previous appearance
            client.Network.OnEventQueueRunning += MaintainAppearance_OnEventQueueRunning;
            client.Network.OnCurrentSimChanged += MaintainAppearance_OnCurrentSimChanged;

            if (client.Network.Login(stalkerFirstName, stalkerLastName, stalkerPassword, "Follow Bot", "User"))
            {
                Console.WriteLine("Logged into Second Life successfully.  Hit enter to gracefully log out.");

                // Hit enter to logout
                Console.ReadLine();
                client.Network.Logout();
            }
            else
            {
                Console.WriteLine("I couldn't log in, here is why: " + client.Network.LoginMessage);
                Console.WriteLine("press enter to close...");
                Console.ReadLine();
            }
        }

        /// <summary>
        /// Follows the other avatar
        /// </summary>
        /// <param name="simulator"></param>
        /// <param name="update"></param>
        /// <param name="regionHandle"></param>
        /// <param name="timeDilation"></param>
        private static void CodeFollow(Simulator simulator, ObjectUpdate update, ulong regionHandle, ushort timeDilation)
        {
            // Exit immediately if it's not an avatar update  
            if (!update.Avatar) { return; }              

            Avatar av;
            client.Network.CurrentSim.ObjectsAvatars.TryGetValue(update.LocalID, out av);

            // If we find the target avatar and it has been updated, move to that location
            if (av != null && av.Name == targetName)
            {
                Vector3 pos = av.Position;

                if (Vector3.Distance(pos, client.Self.SimPosition) > followDistance)
                {
                    if (pos.Z > 1)
                    {
                        client.Self.AutoPilotLocal(Convert.ToInt32(pos.X), Convert.ToInt32(pos.Y), pos.Z);
                    }
                    else
                    {
                        client.Self.AutoPilotCancel();
                    }
                }
            }
        }

        /// <summary>
        /// Sets our avatar appearance to appearance in previous login
        /// </summary>
        /// <param name="simulator"></param>
        private static void MaintainAppearance_OnEventQueueRunning(Simulator simulator)
        {
            if (simulator == client.Network.CurrentSim)
            {
                client.Appearance.SetPreviousAppearance(true);
            }
        }

        /// <summary>
        /// This maintains our appearance when we change sims
        /// </summary>
        /// <param name="PreviousSimulator"></param>
        public static void MaintainAppearance_OnCurrentSimChanged(Simulator PreviousSimulator)
        {
            if (PreviousSimulator != null)
            {
                client.Appearance.SetPreviousAppearance(false);
            }
        }


    }
}
