﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using OpenMetaverse;

namespace CS422API
{
    /// <summary>
    /// Represents a chat event between two avatars
    /// </summary>
    public struct ChatEvent
    {
        public UUID speaker;
        public UUID listener;
        public DateTime timestamp;
        public Vector3 location;
        public string message;
    }

    /// <summary>
    /// Struct to represent meeting of 2+ avatars.  A "meeting" is defined as two
    /// avatars within speaking distance of each other.
    /// 
    /// It is assumed that all avatars were present for the entire duration.
    /// </summary>
    public struct Meeting
    {
        public UUID[] avatars;
        public DateTime start;
        public DateTime end;
        public Vector3 location;

        public Meeting(UUID[] avatars, DateTime start, DateTime end, Vector3 location)
        {
            this.avatars = avatars;
            this.start = start;
            this.end = end;
            this.location = location;
        }
    }
}
