module tutorial(
			clock,
			vga_hsync, vga_vsync, vga_red0, vga_green0, vga_blue0,
			vga_red1, vga_green1, vga_blue1,
			push_button
			);

	// *** INPUTS ***
	input clock;
	input push_button;

	// *** OUTPUTS ***
	output 	vga_hsync, vga_vsync; // sync signals for monitor
	output 	vga_red0, vga_green0, vga_blue0, vga_red1, vga_green1, vga_blue1;

	// Instantiate our VGA output with the push_button wired directly to it
	vgaflag vgaOutput(
					.clock(clock),
					.vga_hsync(vga_hsync), .vga_vsync(vga_vsync),
					.vga_red0(vga_red0), .vga_green0(vga_green0), .vga_blue0(vga_blue0),
					.vga_red1(vga_red1), .vga_green1(vga_green1), .vga_blue1(vga_blue1),
					.enable(push_button)
					);
endmodule	