module vgaflag(clock, vga_hsync , vga_vsync, vga_red0, vga_green0, vga_blue0, 
            	vga_red1, vga_green1, vga_blue1, enable);

	input 	clock;
	input	enable;
	output 	vga_hsync, vga_vsync; // sync signals for monitor
	output 	vga_red0, vga_green0, vga_blue0, vga_red1, vga_green1, vga_blue1;
		
	wire 	[9:0] YPos;	// [0..479]     
	wire 	[10:0] XPos;	// [0...1287]
	wire 	vga_valid;
	wire		Valid;
	
///////////////////////////////////////////

	sync_gen50 syncVGA( .clk(clock), .CounterX(XPos), .CounterY(YPos), .Valid(vga_valid),
	                        .vga_h_sync(vga_hsync), .vga_v_sync(vga_vsync));

///////////////////////////////////////////
// generates the RGB signals based on raster position
	
	// Turn the display on and off based on the enable input
	assign Valid = vga_valid && enable;

	wire red0 = Valid &&  	((XPos <200 ) ||
				 (YPos > 80 ) );
	wire red1 = Valid && 	((XPos > 200) && (XPos  < 400) ||
			      	 (YPos > 80 ) && (YPos  < 160) ); 			
	wire green0 = Valid && 	((XPos > 400) && (XPos  < 600) ||
				 (YPos > 160) && (YPos  < 240) );
	wire green1 =  Valid && ((XPos > 600) && (XPos  < 800) ||
				 (YPos > 240) && (YPos  < 320) );
	wire blue0 = Valid && 	((XPos > 800) && (XPos  < 1000)||
				 (YPos > 320) && (YPos  < 400) );
	wire blue1 = Valid && 	((XPos > 1000)|| (YPos  > 400) );
		
	assign vga_red0   = red0 ? 1'b1 :1'b0;
	
	assign vga_green0 = green0 ? 1'b1:1'b0;
	
	assign vga_blue0  = blue0  ? 1'b1:1'b0;
	
	assign vga_red1   = red1 ? 1'b1: 1'b0;
	
	assign vga_green1 = green1 ?  1'b1: 1'b0;
	
	assign vga_blue1  = blue1?  1'b1:1'b0 ;
endmodule


