function r = convergence_study(fun)

% Convergence study
s = parameter(); 
m = 501;
ss = linspace(-1,1,m);
f_true = zeros(m,1);
for i=1:m
    f_true(i) = fun(ss(i));
end

maxn = 40;
f_poly = zeros(m,1);
figure;
for n=1:maxn
    F = pseudospectral(fun,s,n);
    for i=1:m
        f_poly(i) = evaluate_expansion(F,ss(i));
    end
    plot(ss,f_true,'b-',ss,f_poly,'r-','LineWidth',1.2);
    legend('true','poly'); xlabel('s'); 
    ylim([min(f_true)-0.5 max(f_true)+0.5]);
    drawnow
    fmz(n) = getframe;
end
movie(fmz,10,1);

figure;
semilogy(F.index_set, abs(F.coefficients),'ro',...
    'MarkerSize',10,'MarkerFaceColor','r');
title('Coefficients of Approximation');
xlabel('Polynomial Order');

r=0;