%%
clear all; close all;

%%
% Function to evaluate.
fun = @(s) (s-0.5)^3/(sin(s-0.5));

% Order of polynomial approximation.
n = 20; 

% Defines the weight function (Uniform[-1,1]).
s = parameter(); 

% Compute a Legendre polynomial approximation.
F = pseudospectral(fun,s,n); 

%%
% Plot the coefficients on a log scale.
figure;
semilogy(F.index_set, abs(F.coefficients),'ro',...
    'MarkerSize',10,'MarkerFaceColor','r');
title('Coefficients of Approximation');
xlabel('Polynomial Order');


%%
% Examine the function pointwise.
m = 501;
ss = linspace(-1,1,m);
f_true = zeros(m,1);
f_poly = zeros(m,1);
for i=1:m
    f_true(i) = fun(ss(i)); % compute the truth
    f_poly(i) = evaluate_expansion(F,ss(i)); % compute the approx
end

% Plot it!
figure;
plot(ss,f_true,'b-',...
    ss,f_poly,'r-',...
    'LineWidth',1.2);
title(['Order ',num2str(n)]);
legend('true','poly');
xlabel('s');

%%
convergence_study(fun);

