function cd = cd_ops(m)
% Builds the operators for the convection-diffusion equation.

h=1/m;
x=linspace(h,1-h,m-2);
[XX,YY]=meshgrid(x,x);

% Construct the discretized differential operators.
diff=0.0001; % diffusion coefficient

% Time invariant velocity fields.
VxMAX=-0.01;
nux=VxMAX;
VyMAX=-0.01;
nuy=VyMAX*cos(pi*(x(:)-0.5)).^1.5;

% Central difference first derivative.
K1=(1/(2*h))*gallery('tridiag',m-2,-1,0,1);
K1(1,1)=-1/(2*h); K1(m-2,m-2)=1/(2*h); % Neumann bc's

D1x=nux*kron(K1,speye(m-2)); % x-derivative
D1y=kron(speye(m-2),K1*sparse(1:m-2,1:m-2,nuy)); % y-derivative

% Central difference second derivative with 5-point stencil.
K=gallery('poisson',m-2); 
B=sparse(m-2,m-2); B(1,1)=-1; B(m-2,m-2)=-1;
BB=kron(B,speye(m-2))+kron(speye(m-2),B); % Neumann bc's
D2=(-diff/h^2)*(K+BB);

% store the operators in a struct
cd.A=D1x+D2;
cd.B=D1y;
cd.XX=XX; cd.YY=YY;
cd.ngrid=(m-2)^2;

