function [U,X,Y] = complex_solver2(s,m)

if s(1)<1 || s(1)>3, error('s(1) should be in [1,3], s(1)=%4.2f.',s(1)); end
if s(2)<0 || s(2)>1, error('s(2) should be in [0,1], s(2)=%4.2f.',s(2)); end
if length(s)~=2, error('Dimension of parameter space should be 2.'); end
if mod(m,2), error('m must be even.'); end

% set up the ode integration
cd=cd_ops(m);
tspan=[0 60];
FJac=@(t,y) cd_jac(t,cd);
options=odeset('Stats','off','Jacobian',FJac,'RelTol',1e-8);
odefun=@(t,y) cd_grad(y,t,cd);

% parameter dependent initial condition
Z=s(1)*exp(-100*((cd.XX-0.2).^2+(cd.YY-s(2)).^2));

% run the ode integration
[TT,UU]=ode45(odefun,tspan,Z(:),options);
U=reshape(UU(end,:),m-2,m-2);
X=cd.XX; Y=cd.YY;
