function d = get_sensor_indices(X,Y,sensors)
% Get indices of data corresponding to sensors

if size(sensors,2)~=2, error('Sensors must have two components.'); end

ngrid=numel(X);
M=[X(:) Y(:)];
nsensors=size(sensors,1);
d=zeros(nsensors,1);
for i=1:nsensors
    s=sensors(i,:);
    [ss,ind]=sort(sum((M-ones(ngrid,1)*s).^2,2),'ascend');
    d(i)=ind(1);
end
