% This script will help you get started.
%
% Load the truth matrix to get the grids.
load truth.mat

% Choose up to 10 sensor locations in the spatial domain [0,1]x[0,1]. The
% first column of sensors is the x-coordinates and the second column is the
% y-coordinates.
sensors = [0.8 0.7;
    0.3 0.3;
    0.6 0.2];

% Use the following utility to get the indices of the grid corresponding to
% the sensor locations.
sensor_indices = get_sensor_indices(X_20,Y_20,sensors);

% Get the measurements from the truth images.
measurements = Z_20(sensor_indices)

% The input parameter space is the rectangle [1,3]x[0,1]. Run the code at a
% point in the input space, and extract the values of the output
% corresponding to the sensor locations.
s = [2; 0.5];
[Z,X,Y] = complex_solver2(s,152);
measurements = Z(sensor_indices)

% Plot the solution.
figure;
surf(X,Y,Z,'EdgeColor','none'); view(2);
xlim([0 1]); ylim([0 1]); axis square;
colorbar

