% This script will help you get started using the packages DACE and
% SPINTERP for surrogate modeling. This script assumes that you have the
% functions from DACE and SPINTERP in your MATLAB path. 
%
%% DACE
% DACE constructs the Kriging surrogate at a point in the parameter space
% given samples of the function.

% Choose random points in the parameter space [0 1]x[0 1]. 
d = 2; % dimension of the parameter space
nsamples = 200;
S = rand(nsamples,2);

% Compute the function values at the points in the parameter space. The
% included function myfun returns two values given the input parameters.
F = zeros(nsamples,2);
for i=1:nsamples
    F(i,:) = myfun(S(i,:));
end

% Use DACE to fit a correlation model.
theta0 = [0.5 0.5]; % An initial guess of for the correlation lengths.
lob = [0.001 0.001]; % A lower bound on the correlation lengths.
upb = [1 1]; % An upper bound on the correlation lengths.
[dmodel,perf] = dacefit(S,F,@regpoly0,@corrgauss,theta0,lob,upb);

% Use the DACE model to interpolate the function at a point in the
% parameter space.
s = [0.5 0.5];
f_dace = predictor(s,dmodel);
f_true = myfun(s);

fprintf('==== DACE ====\n');
fprintf('DACE interpolant:\t %6.4f\t %6.4f\n',f_dace(1),f_dace(2));
fprintf('True function:\t\t %6.4f\t %6.4f\n',f_true(1),f_true(2));

%% Tensor Product Pseudospectral
% Construct a tensor product pseudospectral approximation of the outputs
% with respect to the inputs. 

% Set up the variable information.
variables = [parameter('Legendre',0,1); parameter('Legendre',0,1)];

% Set the order of the polynomial expansion in each variable. 
order = [4 4];

% Build the tensor product pseudospectral approximation.
X = pseudospectral(@myfun,variables,order);

% Evaluate the interpolant.
f_pseudo = evaluate_expansion(X,s');

fprintf('==== Pseudospectral ====\n');
fprintf('Pseudospectral interpolant:\t %6.4f\t %6.4f\n',f_pseudo(1),f_pseudo(2));
fprintf('True function:\t\t\t %6.4f\t %6.4f\n',f_true(1),f_true(2));






