!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! program qdotddTest
!
! tests subroutine qdotdd( v,w,n,x,y ) in module qdotddModule.f90.
!
! Ding Ma and Michael Saunders, MS&E, Stanford University.
! dingma@stanford.edu, saunders@stanford.edu
!
! 21 Sep 2014: First version of qdotddTest.f90.
!              gfortran -O -Wall -o qdotddTest qdotddModule.f90 qdotddTest.f90
!              ./qdotddTest
! 29 Dec 2014: Random vectors v, w implemented.  The code
!                 call qdotdd( v,w,n,x,y )
!                 q = real(x,qp) + real(y,qp)
!              gives the dotproduct q = v'*w in quad precision
!              using only real(8) floating-point.
!              The mean relative error in q appears to be around 1e-30
!              (not quite quad precision = 1e-34).
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

program qdotddTest

  use qdotddModule, only : qdotdd
  implicit none

  integer, parameter   :: ip = 4, dp = 8, qp = 16
  integer, parameter   :: nmax = 10000

  integer              :: i, n, n0, ndot
  real(qp)             :: e, emean, emax
  real(dp)             :: x, y
  real(dp)             :: v(nmax), w(nmax)
  real(qp)             :: q, qdot
  real(qp)             :: qv(nmax), qw(nmax)

  intrinsic            :: random_seed, random_number
  integer              :: seedsize
  integer, allocatable :: seed(:)

!   v(1)  = 3.14159_dp
!   w(1)  = 1.41421_dp

!   do i = 2, nmax
!      v(i)  =  v(i-1)*0.9_dp
!      w(i)  = -w(i-1)*0.8_dp
!   end do

  call random_seed( size=seedsize )
  allocate( seed(seedsize) )
  call random_seed( put=seed )
  call random_number( v )         ! v = v(1:nmax)
  call random_number( w )

  v = v - 0.5_dp                  ! random arrays in (-0.5, 0.5)
  w = w - 0.5_dp

  write(*,*) ' '
  write(*,*) 'First few elements of random v and w:'
  do i = 1, 5
     write(*,*) i, v(i), w(i)
  end do

  write(*,*) ' '
  write(*,*) 'Last  few elements of random v and w:'
  do i = nmax-4, nmax
     write(*,*) i, v(i), w(i)
  end do

  qv    = real(v,qp)
  qw    = real(w,qp)
  n0    = nmax/10
  ndot  = 0
  emean = 0_qp
  emax  = 0_qp

  do n = n0, nmax, n0
     ndot  = ndot + 1
     call qdotdd( v(1:n),w(1:n),n,x,y )
     q     = real(x,qp) + real(y,qp)
     qdot  = dot_product( qv(1:n), qw(1:n) )

     e     = (q - qdot)/qdot
     e     = abs(e)
     emean = emean + e
     emax  = max( emax, e )
     write(*,*)
     write(*,*) 'n      =', n
     write(*,*) 'q      =', q
     write(*,*) 'qdot   =', qdot
     write(*,*) 'relerr =', real(e,4)
  end do

  write(*,*)
  write(*,*) 'average relerr =', real(emean/ndot,4)
  write(*,*) 'max     relerr =', real(emax,4)

end program qdotddTest
